/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class FollowFlockLeader
extends Behavior<AbstractFlockFish> {
    private final float speedModifier;

    public FollowFlockLeader(float speedModifier) {
        super(Map.of(MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED, FOTMemoryModuleTypes.FLOCK_LEADER, MemoryStatus.VALUE_PRESENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected boolean canStillUse(ServerLevel level, AbstractFlockFish entity, long gameTime) {
        Brain brain = entity.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.IS_PANICKING) || brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET) || brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        if (entity.hasLeader()) {
            AbstractFlockFish leader = entity.getLeader();
            return entity.hasLineOfSight((Entity)leader) && (!leader.getBrain().hasMemoryValue(MemoryModuleType.IS_TEMPTED) || (Boolean)leader.getBrain().getMemory(MemoryModuleType.IS_TEMPTED).get() == false);
        }
        return false;
    }

    protected void tick(ServerLevel level, AbstractFlockFish owner, long gameTime) {
        AbstractFlockFish flockLeader = owner.getLeader();
        Brain brain = owner.getBrain();
        int closeDistance = 2;
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)flockLeader, true));
        if (owner.distanceToSqr((Entity)flockLeader) < (double)closeDistance) {
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        } else if (owner.distanceToSqr((Entity)flockLeader) > 6.0) {
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)flockLeader, false), this.speedModifier * 3.0f, closeDistance));
        } else {
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)flockLeader, false), this.speedModifier, closeDistance));
        }
    }
}

