/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Bucketable;

public class FishBreaching<E extends LivingEntity>
extends Behavior<E> {
    private static final int[] STEPS_TO_CHECK = new int[]{1, 2, 3};
    private final float jumpVelocity;
    private final float horizontalVelocity;
    private final UniformInt chance;

    public FishBreaching(UniformInt chance, float jumpVelocity, float horizontalVelocity) {
        super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.BREACHED_TICK, MemoryStatus.REGISTERED));
        this.jumpVelocity = jumpVelocity;
        this.horizontalVelocity = horizontalVelocity;
        this.chance = chance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        Bucketable bucketable;
        if (owner instanceof Bucketable && (bucketable = (Bucketable)owner).fromBucket()) {
            return false;
        }
        Direction direction = owner.getMotionDirection();
        int stepX = direction.getStepX();
        int stepZ = direction.getStepZ();
        BlockPos blockPos = owner.blockPosition();
        for (int scale : STEPS_TO_CHECK) {
            if (this.waterIsClear(owner, blockPos, stepX, stepZ, scale) && this.surfaceIsClear(owner, blockPos, stepX, stepZ, scale)) continue;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel level, E entity, long gameTime) {
        Direction direction = entity.getMotionDirection();
        entity.playSound(FOTSoundEvents.FISH_JUMP);
        entity.setDeltaMovement(entity.getDeltaMovement().add((double)((float)direction.getStepX() * this.horizontalVelocity), (double)this.jumpVelocity, (double)((float)direction.getStepZ() * this.horizontalVelocity)));
        entity.getBrain().setMemory(FOTMemoryModuleTypes.BREACHED_TICK, (Object)20);
    }

    protected void stop(ServerLevel level, E entity, long gameTime) {
        entity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)this.chance.sample(level.random));
        entity.setXRot(0.0f);
    }

    private boolean waterIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        blockPos = blockPos.offset(dx * scale, 0, dz * scale);
        return entity.level().getFluidState(blockPos).is(FluidTags.WATER) && !entity.level().getBlockState(blockPos).blocksMotion();
    }

    private boolean surfaceIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        return entity.level().getBlockState(blockPos.offset(dx * scale, 1, dz * scale)).isAir() && entity.level().getBlockState(blockPos.offset(dx * scale, 2, dz * scale)).isAir();
    }
}

