/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.entity.ai.behavior.GoToClosestWreckerLocated;
import com.stevekung.fishofthieves.entity.ai.behavior.GoToLowBrightness;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class WreckerAi {
    public static Brain<?> makeBrain(Brain<Wrecker> brain) {
        WreckerAi.initCoreActivity(brain);
        WreckerAi.initIdleActivity(brain);
        WreckerAi.initFightActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Wrecker fish) {
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            fish.getBrain().setActiveActivityToFirstValid(List.of(Activity.FIGHT, Activity.IDLE));
        } else {
            fish.getBrain().setActiveActivityToFirstValid(List.of(Activity.IDLE));
        }
    }

    public static void initMemories(Wrecker fish) {
        if (!fish.fromBucket()) {
            fish.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)AbstractThievesFishAi.TIME_BETWEEN_BREACH.sample(fish.getRandom()));
        }
    }

    private static void initCoreActivity(Brain<Wrecker> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<Wrecker> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne(List.of(Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.15f)), (Object)1), Pair.of((Object)((Object)new GoToClosestWreckerLocated(2.0f, 8)), (Object)2), Pair.of((Object)((Object)new GoToLowBrightness(2.0f, 4)), (Object)3), Pair.of(new FishBreaching(AbstractThievesFishAi.TIME_BETWEEN_BREACH, 0.2f, 0.12f), (Object)4)))), (Object)Pair.of((Object)2, (Object)StartAttacking.create(WreckerAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new GateBehavior(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT), Set.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, List.of(Pair.of((Object)RandomStroll.swim((float)0.8f), (Object)2), Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.8f, (int)3), (Object)3), Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWaterOrBubble), (Object)5))))));
    }

    private static void initFightActivity(Brain<Wrecker> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.25f), (Object)MeleeAttack.create((int)20)), MemoryModuleType.ATTACK_TARGET);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Wrecker fish) {
        return fish.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }
}

