/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends AbstractFishVariant>
extends PartyFish,
VariantHolder<Holder<T>> {
    public static final Ingredient WORMS = Ingredient.of(FOTTags.Items.WORMS);
    public static final Ingredient EARTHWORMS_FOOD = Ingredient.of(FOTTags.Items.EARTHWORMS_FOOD);
    public static final Ingredient GRUBS_FOOD = Ingredient.of(FOTTags.Items.GRUBS_FOOD);
    public static final Ingredient LEECHES_FOOD = Ingredient.of(FOTTags.Items.LEECHES_FOOD);
    public static final String VARIANT_TAG = "variant";
    public static final String CREATIVE_TAG = "creative";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public ResourceKey<? extends Registry<T>> getRegistryKey();

    public ResourceKey<T> getDefaultKey();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(ItemStack var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public boolean isFishBreached(Brain<?> brain) {
        return brain.hasMemoryValue(FOTMemoryModuleTypes.BREACHED_TICK) && (Integer)brain.getMemory(FOTMemoryModuleTypes.BREACHED_TICK).get() > 0;
    }

    default public boolean isTreasured() {
        return ((AbstractFishVariant)((Holder)this.getVariant()).value()).treasured().isPresent();
    }

    default public void saveToBucket(ItemStack bucket) {
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, compoundTag -> {
            compoundTag.putString(this.getVariantKey(), ((Holder)this.getVariant()).unwrapKey().orElse(this.getDefaultKey()).location().toString());
            if (this.isTrophy()) {
                compoundTag.putBoolean(HAS_FED_TAG, this.hasFed());
                compoundTag.putBoolean(TROPHY_TAG, this.isTrophy());
            }
            if (this.isNoFlip()) {
                compoundTag.putBoolean(NO_FLIP_TAG, this.isNoFlip());
            }
        });
    }

    default public void loadFromBucket(CompoundTag compound, RegistryAccess registryAccess) {
        Optional.ofNullable(ResourceLocation.tryParse((String)compound.getString(this.getVariantKey()))).map(resourceLocation -> ResourceKey.create(this.getRegistryKey(), (ResourceLocation)resourceLocation)).flatMap(resourceKey -> registryAccess.registryOrThrow(this.getRegistryKey()).getHolder(resourceKey)).ifPresent(arg_0 -> ((ThievesFish)this).setVariant(arg_0));
        if (compound.contains(TROPHY_TAG)) {
            this.setTrophy(compound.getBoolean(TROPHY_TAG));
        }
        if (compound.contains(HAS_FED_TAG)) {
            this.setHasFed(compound.getBoolean(HAS_FED_TAG));
        }
        if (compound.contains(NO_FLIP_TAG)) {
            this.setNoFlip(compound.getBoolean(NO_FLIP_TAG));
        }
    }

    default public SpawnGroupData defaultFinalizeSpawn(ServerLevelAccessor accessor, LivingEntity livingEntity, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        Holder<T> holder = AbstractFishVariant.getSpawnVariant(accessor.getLevel(), accessor.registryAccess(), this.getRegistryKey(), this.getDefaultKey(), livingEntity, spawnType == MobSpawnType.BUCKET);
        this.setVariant(holder);
        if (livingEntity.getRandom().nextFloat() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.setHealth(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        return spawnData;
    }

    private String getVariantKey() {
        return this.getRegistryKey().location().getPath();
    }

    default public float calculateTreasuredGlow(Level level, BlockPos blockPos) {
        long dayTime = level.getDayTime() % 24000L;
        int skyLight = level.getBrightness(LightLayer.SKY, blockPos);
        float glowIntensityWithSkylight = (float)(15 - skyLight) / 15.0f;
        int glowingNightTimeStart = 12500;
        int glowingNightTimeEnd = 13500;
        int glowingMorningTimeStart = 22700;
        if (dayTime >= (long)glowingNightTimeStart && dayTime < (long)glowingNightTimeEnd) {
            glowIntensityWithSkylight = Math.min(0.5f, Math.max((float)(dayTime - (long)glowingNightTimeStart) / 1000.0f, glowIntensityWithSkylight) + 0.05f);
        } else if (dayTime >= (long)glowingNightTimeEnd && dayTime < (long)glowingMorningTimeStart) {
            glowIntensityWithSkylight = 0.5f;
        } else if (dayTime >= (long)glowingMorningTimeStart) {
            glowIntensityWithSkylight = Math.max(glowIntensityWithSkylight, 0.5f - (float)(dayTime - (long)glowingMorningTimeStart) / 1000.0f + 0.05f);
        }
        return Math.min(glowIntensityWithSkylight, (float)(15 - level.getBrightness(LightLayer.BLOCK, blockPos)) / 15.0f);
    }
}

