/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractThievesFish<T extends AbstractFishVariant>
extends AbstractFish
implements ThievesFish<T> {
    private static final EntityDataAccessor<Boolean> TROPHY = SynchedEntityData.defineId(AbstractThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_FED = SynchedEntityData.defineId(AbstractThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> NO_FLIP = SynchedEntityData.defineId(AbstractThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final List<SensorType<? extends Sensor<? super AbstractThievesFish<?>>>> SENSOR_TYPES = List.of(SensorType.NEAREST_LIVING_ENTITIES, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, FOTSensorTypes.NEAREST_MAGMA_BLOCK, SensorType.HURT_BY);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, FOTMemoryModuleTypes.BREACHED_TICK);
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final ResourceKey<T> resourceKey;

    public AbstractThievesFish(EntityType<? extends AbstractFish> entityType, Level level, ResourceKey<? extends Registry<T>> registryKey, ResourceKey<T> resourceKey) {
        super(entityType, level);
        this.refreshDimensions();
        this.registryKey = registryKey;
        this.resourceKey = resourceKey;
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Override
    public ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    @Override
    public ResourceKey<T> getDefaultKey() {
        return this.resourceKey;
    }

    protected void registerGoals() {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TROPHY, (Object)false);
        builder.define(HAS_FED, (Object)false);
        builder.define(NO_FLIP, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("variant", ((Holder)this.getVariant()).unwrapKey().orElse(this.getDefaultKey()).location().toString());
        compound.putBoolean("Trophy", this.isTrophy());
        compound.putBoolean("HasFed", this.hasFed());
        compound.putBoolean("NoFlip", this.isNoFlip());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Optional.ofNullable(ResourceLocation.tryParse((String)compound.getString("variant"))).map(resourceLocation -> ResourceKey.create(this.getRegistryKey(), (ResourceLocation)resourceLocation)).flatMap(resourceKey -> this.registryAccess().registryOrThrow(this.getRegistryKey()).getHolder(resourceKey)).ifPresent(arg_0 -> ((AbstractThievesFish)this).setVariant(arg_0));
        this.setTrophy(compound.getBoolean("Trophy"));
        this.setHasFed(compound.getBoolean("HasFed"));
        this.setNoFlip(compound.getBoolean("NoFlip"));
        AbstractThievesFishAi.initMemories(this);
    }

    public void saveToBucketTag(ItemStack itemStack) {
        super.saveToBucketTag(itemStack);
        this.saveToBucket(itemStack);
    }

    public void loadFromBucketTag(CompoundTag compound) {
        super.loadFromBucketTag(compound);
        this.loadFromBucket(compound, this.registryAccess());
        if (compound.contains("creative")) {
            Registry registry = this.registryAccess().registryOrThrow(this.registryKey);
            Optional muha = Util.getRandomSafe(registry.holders().filter(holder -> ((AbstractFishVariant)holder.value()).treasured().isEmpty()).toList(), (RandomSource)this.getRandom());
            this.setVariant((Holder)muha.orElseGet(() -> registry.getHolderOrThrow(this.resourceKey)));
            this.setTrophy(compound.contains("Trophy") ? compound.getBoolean("Trophy") : this.random.nextBoolean());
        }
    }

    public float getWalkTargetValue(BlockPos blockPos, LevelReader level) {
        if (AbstractThievesFishAi.isPosNearNearestRepellent(this, blockPos)) {
            return -1.0f;
        }
        return super.getWalkTargetValue(blockPos, level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed() && !this.isTreasured()) {
            if (!this.level().isClientSide()) {
                this.growUp(player, itemStack);
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        spawnGroupData = super.finalizeSpawn(accessor, difficulty, spawnType, spawnGroupData);
        return this.defaultFinalizeSpawn(accessor, (LivingEntity)this, spawnType, spawnGroupData);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (TROPHY.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.setNoFlip(!this.hasImpulse && this.isFishBreached(this.getBrain()));
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.entityData.get(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.entityData.set(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.entityData.get(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.entityData.set(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.entityData.set(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.entityData.get(NO_FLIP);
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        if (this.isTreasured()) {
            return this.calculateTreasuredGlow(this.level(), this.blockPosition());
        }
        return ThievesFish.super.getGlowBrightness(ageInTicks);
    }

    private void growUp(Player player, ItemStack itemStack) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        if (this.random.nextInt(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.setHealth(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

