/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.debug.SchoolingFishDebug;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchoolingThievesFish<T extends AbstractFishVariant>
extends AbstractFlockFish
implements ThievesFish<T> {
    private static final EntityDataAccessor<Boolean> TROPHY = SynchedEntityData.defineId(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_FED = SynchedEntityData.defineId(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> NO_FLIP = SynchedEntityData.defineId(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final List<SensorType<? extends Sensor<? super AbstractFlockFish>>> SENSOR_TYPES = List.of(SensorType.NEAREST_LIVING_ENTITIES, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, FOTSensorTypes.NEAREST_SCHOOLING_THIEVES_FISH, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.NEAREST_FLOCK_LEADER, SensorType.HURT_BY);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.AVOID_TARGET, FOTMemoryModuleTypes.SCHOOL_SIZE, FOTMemoryModuleTypes.FLOCK_LEADER, FOTMemoryModuleTypes.IS_FLOCK_LEADER, FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, FOTMemoryModuleTypes.FLOCK_FOLLOWERS, FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, FOTMemoryModuleTypes.BREACHED_TICK);
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final ResourceKey<T> resourceKey;

    public AbstractSchoolingThievesFish(EntityType<? extends AbstractSchoolingFish> entityType, Level level, ResourceKey<? extends Registry<T>> registryKey, ResourceKey<T> resourceKey) {
        super(entityType, level);
        this.refreshDimensions();
        this.registryKey = registryKey;
        this.resourceKey = resourceKey;
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Override
    public ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    @Override
    public ResourceKey<T> getDefaultKey() {
        return this.resourceKey;
    }

    public void tick() {
        super.tick();
        SchoolingFishDebug.tick(this);
        if (this.isFollower() && this.hasLeader() && !this.getLeader().isAlive()) {
            AbstractSchoolingThievesFishAi.resetMemories(this);
        }
    }

    protected void registerGoals() {
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide() && this.isDeadOrDying() && this.isFollower()) {
            this.getLeader().removeFollower();
        }
        super.remove(reason);
    }

    @Override
    public boolean isFollower() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER) && (Boolean)this.getBrain().getMemory(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER).get() != false;
    }

    public void stopFollowing() {
        this.getLeader().removeFollower();
        this.getBrain().eraseMemory(FOTMemoryModuleTypes.FLOCK_LEADER);
    }

    @Override
    public boolean canBeFollowed() {
        return this.isLeader() && this.getSchoolSize() < this.getMaxSchoolSize();
    }

    public boolean hasFollowers() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.FLOCK_FOLLOWERS) && !this.getFlockFollowers().isEmpty() && this.getSchoolSize() > 1;
    }

    @Override
    public boolean isLeader() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.IS_FLOCK_LEADER) && (Boolean)this.getBrain().getMemory(FOTMemoryModuleTypes.IS_FLOCK_LEADER).get() != false;
    }

    public List<AbstractFlockFish> getFlockFollowers() {
        return (List)this.getBrain().getMemory(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get();
    }

    @Override
    public void startFollowingThievesFish(AbstractFlockFish leader) {
        this.getBrain().setMemory(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)leader);
        this.getBrain().setMemory(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, (Object)true);
        leader.getBrain().setMemory(FOTMemoryModuleTypes.IS_FLOCK_LEADER, (Object)true);
        leader.addFollower();
    }

    @Override
    public void addThievesFishFollowers(Stream<AbstractFlockFish> followers) {
        List<AbstractFlockFish> list = followers.limit(this.getMaxSchoolSize() - this.getSchoolSize()).filter(fish -> fish != this).collect(Collectors.toList());
        boolean hasFlockFollowerMem = this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.FLOCK_FOLLOWERS);
        list.forEach(fish -> {
            fish.startFollowingThievesFish(this);
            if (hasFlockFollowerMem) {
                this.getFlockFollowers().add((AbstractFlockFish)((Object)fish));
            }
        });
        if (!list.isEmpty() && !hasFlockFollowerMem) {
            this.getBrain().setMemory(FOTMemoryModuleTypes.FLOCK_FOLLOWERS, list);
        }
    }

    @Override
    public boolean hasFollowCooldown() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS);
    }

    @Override
    public boolean isSameType(AbstractFlockFish other) {
        return this.getType() == other.getType();
    }

    @Override
    public boolean hasLeader() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.FLOCK_LEADER);
    }

    @Override
    public AbstractFlockFish getLeader() {
        return (AbstractFlockFish)((Object)this.getBrain().getMemory(FOTMemoryModuleTypes.FLOCK_LEADER).get());
    }

    @Override
    public void addFollower() {
        this.getBrain().setMemory(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)(this.getSchoolSize() + 1));
    }

    @Override
    public void removeFollower() {
        this.removeFollower(true);
    }

    public void removeFollower(boolean eraseIsLeader) {
        this.getBrain().setMemory(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)(this.getSchoolSize() - 1));
        if (eraseIsLeader && this.getSchoolSize() == 1) {
            this.getBrain().eraseMemory(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
        }
    }

    @Override
    public int getSchoolSize() {
        return this.getBrain().hasMemoryValue(FOTMemoryModuleTypes.SCHOOL_SIZE) ? (Integer)this.getBrain().getMemory(FOTMemoryModuleTypes.SCHOOL_SIZE).get() : 1;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TROPHY, (Object)false);
        builder.define(HAS_FED, (Object)false);
        builder.define(NO_FLIP, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("variant", ((Holder)this.getVariant()).unwrapKey().orElse(this.getDefaultKey()).location().toString());
        compound.putBoolean("Trophy", this.isTrophy());
        compound.putBoolean("HasFed", this.hasFed());
        compound.putBoolean("NoFlip", this.isNoFlip());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Optional.ofNullable(ResourceLocation.tryParse((String)compound.getString("variant"))).map(resourceLocation -> ResourceKey.create(this.getRegistryKey(), (ResourceLocation)resourceLocation)).flatMap(resourceKey -> this.registryAccess().registryOrThrow(this.getRegistryKey()).getHolder(resourceKey)).ifPresent(arg_0 -> ((AbstractSchoolingThievesFish)this).setVariant(arg_0));
        this.setTrophy(compound.getBoolean("Trophy"));
        this.setHasFed(compound.getBoolean("HasFed"));
        this.setNoFlip(compound.getBoolean("NoFlip"));
        AbstractSchoolingThievesFishAi.resetMemories(this);
    }

    public void saveToBucketTag(ItemStack itemStack) {
        super.saveToBucketTag(itemStack);
        this.saveToBucket(itemStack);
    }

    public void loadFromBucketTag(CompoundTag compound) {
        super.loadFromBucketTag(compound);
        this.loadFromBucket(compound, this.registryAccess());
        if (compound.contains("creative")) {
            Registry registry = this.registryAccess().registryOrThrow(this.registryKey);
            Optional muha = Util.getRandomSafe(registry.holders().filter(holder -> ((AbstractFishVariant)holder.value()).treasured().isEmpty()).toList(), (RandomSource)this.getRandom());
            this.setVariant((Holder)muha.orElseGet(() -> registry.getHolderOrThrow(this.resourceKey)));
            this.setTrophy(compound.contains("Trophy") ? compound.getBoolean("Trophy") : this.random.nextBoolean());
        }
    }

    public float getWalkTargetValue(BlockPos blockPos, LevelReader level) {
        if (AbstractThievesFishAi.isPosNearNearestRepellent(this, blockPos)) {
            return -1.0f;
        }
        return super.getWalkTargetValue(blockPos, level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed() && !this.isTreasured()) {
            if (!this.level().isClientSide()) {
                this.growUp(player, itemStack);
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (this.level().isClientSide()) {
            return false;
        }
        if (hurt && source.getEntity() instanceof LivingEntity) {
            AbstractSchoolingThievesFishAi.wasHurtBy(this);
        }
        return hurt;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        spawnGroupData = super.finalizeSpawn(accessor, difficulty, spawnType, spawnGroupData);
        return this.defaultFinalizeSpawn(accessor, (LivingEntity)this, spawnType, spawnGroupData);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (TROPHY.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.setNoFlip(!this.hasImpulse && this.isFishBreached(this.getBrain()));
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.entityData.get(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.entityData.set(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.entityData.get(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.entityData.set(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.entityData.set(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.entityData.get(NO_FLIP);
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        if (this.isTreasured()) {
            return this.calculateTreasuredGlow(this.level(), this.blockPosition());
        }
        return ThievesFish.super.getGlowBrightness(ageInTicks);
    }

    private void growUp(Player player, ItemStack itemStack) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        if (this.random.nextInt(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.setHealth(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

