/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.mixin.client.accessor.EntityRenderDispatcherAccessor;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;

public class ShoalRenderer
extends EntityRenderer<Shoal> {
    private final EntityRenderDispatcher entityRenderDispatcher;

    public ShoalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.entityRenderDispatcher = context.getEntityRenderDispatcher();
    }

    public void render(Shoal shoal, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float ageInTicks = (float)shoal.tickCount + partialTicks;
        List<LivingEntity> list = shoal.getShoalFishClient();
        float offsetPerFish = 360.0f / (float)list.size();
        float modifier = 15.0f;
        float rotationModifier = 0.25f;
        float radiusBase = 1.0f;
        float radiusMod = 0.1f;
        float v = 0.125f;
        poseStack.translate(-0.05f, 0.0f, 0.0f);
        for (int index = 0; index < list.size(); ++index) {
            LivingEntity entity = list.get(index);
            float offset = offsetPerFish * (float)index;
            float deg = (int)(ageInTicks / rotationModifier % 360.0f + offset);
            float rad = (float)((double)(deg / 180.0f) * Math.PI);
            float radiusX = (float)((double)radiusBase + (double)radiusMod * Math.sin(ageInTicks / modifier));
            float radiusZ = (float)((double)radiusBase + (double)radiusMod * Math.cos(ageInTicks / modifier));
            float x = (float)((double)radiusX * Math.cos(rad));
            float z = (float)((double)radiusZ * Math.sin(rad));
            float y = (float)Math.cos((ageInTicks + (float)(50 * index)) / 5.0f) / 10.0f;
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            float yRotate = Math.max(0.6f, Mth.sin((float)(ageInTicks * 0.1f)) / 4.0f);
            float zRotate = (float)Math.cos(0.1f * ageInTicks) / 16.0f;
            poseStack.translate(v /= 2.0f, v, v);
            poseStack.mulPose(new Quaternionf().rotateAxis(-rad, 0.0f, yRotate, zRotate));
            poseStack.translate(-v, -v, -v);
            v *= 2.0f;
            this.renderEntityInShoal((Entity)entity, ageInTicks, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.popPose();
        }
        poseStack.popPose();
        super.render((Entity)shoal, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderEntityInShoal(Entity entity, float ageInTicks, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityRenderer<?> renderer = ((EntityRenderDispatcherAccessor)this.entityRenderDispatcher).getRenderers().get(entity.getType());
        renderer.render(entity, entityYaw, ageInTicks, poseStack, buffer, packedLight);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
                float yBodyRot = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
                float yHeadRot = Mth.rotLerp((float)partialTicks, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
                float netHeadYaw = yHeadRot - yBodyRot;
                float limbSwingAmount = 0.0f;
                float limbSwing = 0.0f;
                float headPitch = Mth.lerp((float)partialTicks, (float)livingEntity.xRotO, (float)livingEntity.getXRot());
                if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
                    headPitch *= -1.0f;
                    netHeadYaw *= -1.0f;
                }
                if (!livingEntity.isPassenger() && livingEntity.isAlive()) {
                    limbSwingAmount = livingEntity.walkAnimation.speed(partialTicks);
                    limbSwing = livingEntity.walkAnimation.position(partialTicks);
                    if (livingEntity.isBaby()) {
                        limbSwing *= 3.0f;
                    }
                    if (limbSwingAmount > 1.0f) {
                        limbSwingAmount = 1.0f;
                    }
                }
                EntityModel model = livingEntityRenderer.getModel();
                model.prepareMobModel((Entity)livingEntity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    public ResourceLocation getTextureLocation(Shoal entity) {
        return null;
    }
}

