/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;

public class StructureCenterPosDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private final List<Pair<BlockPos, ResourceLocation>> structurePosList = new ArrayList<Pair<BlockPos, ResourceLocation>>();

    public StructureCenterPosDebugRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, double camX, double camY, double camZ) {
        Optional<Pair> optional;
        int distFromStructure = Integer.MAX_VALUE;
        BlockPos entityPos = this.minecraft.player.blockPosition();
        List posList = this.structurePosList.stream().distinct().toList();
        posList.forEach(pair -> {
            BlockPos blockPos = (BlockPos)pair.getFirst();
            if (blockPos.distManhattan((Vec3i)entityPos) < 512) {
                AABB aabb = new AABB((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (double)((float)blockPos.getX() + 1.0f), (double)((float)blockPos.getY() + 1.0f), (double)((float)blockPos.getZ() + 1.0f));
                DebugRenderer.renderFilledBox((PoseStack)poseStack, (MultiBufferSource)buffer, (AABB)aabb.move(-camX, -camY, -camZ), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            }
        });
        if (FishOfThieves.CONFIG.debug.displayStructureCenterPosInfo && (optional = posList.stream().filter(pair -> ((BlockPos)pair.getFirst()).distManhattan((Vec3i)entityPos) <= FishOfThieves.CONFIG.debug.structureCenterPosRangeLimit).min(Comparator.comparing(pair -> ((BlockPos)pair.getFirst()).distManhattan((Vec3i)entityPos)))).isPresent()) {
            BlockPos blockPos = (BlockPos)optional.get().getFirst();
            int structureDist = blockPos.distManhattan((Vec3i)entityPos);
            if (structureDist < distFromStructure) {
                distFromStructure = structureDist;
            }
            this.minecraft.gui.setOverlayMessage((Component)Component.literal((String)(String.valueOf(optional.get().getSecond()) + ": " + distFromStructure + ", pos: " + blockPos.toShortString())), false);
        }
    }

    public void clear() {
        this.structurePosList.clear();
    }

    public void addStructure(List<Pair<BlockPos, ResourceLocation>> structurePosList) {
        this.structurePosList.addAll(structurePosList);
    }
}

