/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.block.FishPlaqueBlock;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FishPlaqueRenderer
implements BlockEntityRenderer<FishPlaqueBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public FishPlaqueRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(FishPlaqueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        Entity entity = blockEntity.getOrCreateDisplayEntity(blockEntity.getLevel());
        if (entity != null) {
            float animationTick = blockEntity.getAnimation(partialTick);
            BlockState blockState = blockEntity.getBlockState();
            Direction facing = (Direction)blockState.getValue((Property)FishPlaqueBlock.FACING);
            int rotation = (Integer)blockState.getValue((Property)FishPlaqueBlock.ROTATION) - 1;
            EntityType entityType = entity.getType();
            if (((Boolean)blockState.getValue((Property)FishPlaqueBlock.POWERED)).booleanValue() && entityType.is(FOTTags.EntityTypes.FISH_PLAQUE_HORIZONTAL_RENDER_ON_POWERED)) {
                entity.wasTouchingWater = true;
            }
            boolean isHorizontal = entity.wasTouchingWater || entityType.is(FOTTags.EntityTypes.FISH_PLAQUE_HORIZONTAL_RENDER);
            float scale = 0.53125f;
            float stepMultiplier = isHorizontal ? 0.3f : 0.4f;
            float maxScale = Math.max(entity.getBbWidth(), entity.getBbHeight());
            float yDegree = -facing.toYRot() + 90.0f;
            Vec3 vec3 = new Vec3((double)((float)facing.getStepX() * stepMultiplier), (double)(-scale), (double)((float)facing.getStepZ() * stepMultiplier));
            if (maxScale > 1.0f) {
                scale /= maxScale;
            }
            poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
            poseStack.mulPose(Axis.YP.rotationDegrees(yDegree));
            poseStack.translate(0.0f, -0.02f, 0.0f);
            if (isHorizontal) {
                poseStack.mulPose(Axis.XP.rotationDegrees((float)rotation * 360.0f / 8.0f));
                poseStack.translate(0.0f, -0.1f, 0.0f);
            } else {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees((float)(-rotation) * 360.0f / 8.0f));
            }
            entity.setYHeadRot(0.0f);
            entity.setYBodyRot(0.0f);
            poseStack.scale(scale, scale, scale);
            this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, animationTick, poseStack, bufferSource, packedLight);
            entity.wasTouchingWater = false;
        }
        poseStack.popPose();
    }
}

