/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class PlentifinModel<T extends Plentifin>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("plentifin"), "main");
    private final ModelPart main;
    private final ModelPart body_back;
    private final ModelPart body_back_2;

    public PlentifinModel(ModelPart part) {
        super(RenderType::entityCutout);
        this.main = part.getChild("main");
        this.body_back = this.main.getChild("body_back");
        this.body_back_2 = this.body_back.getChild("body_back_2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition main = partDefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.5f, (float)0.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.5f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(9, 14).addBox(-1.0f, -0.07f, -1.97f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.25f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, -1.835f, -2.975f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.515f, (float)-3.575f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = main.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.1f, -4.5f, 2.0f, 6.0f, 5.0f, CubeDeformation.NONE).texOffs(0, 7).addBox(0.0f, -8.65f, -3.5f, 0.0f, 3.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)3.5f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(14, 20).addBox(-0.75f, -3.65f, -3.5f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.75f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.9599f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(14, 17).addBox(0.0f, -3.65f, 0.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.75f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.9599f, (float)0.0f));
        PartDefinition body_back = main.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(14, 8).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 2.0f, CubeDeformation.NONE).texOffs(1, 11).addBox(0.0f, -5.15f, 0.0f, 0.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        body_back.addOrReplaceChild("right_fin_r2", CubeListBuilder.create().texOffs(6, 14).addBox(0.0f, 0.0f, 0.5f, 0.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)1.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.addOrReplaceChild("left_fin_r2", CubeListBuilder.create().texOffs(6, 16).addBox(0.0f, 0.0f, 0.5f, 0.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5f, (float)1.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        body_back.addOrReplaceChild("body_back_2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 15).addBox(0.0f, -2.65f, 1.0f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        if (!entity.isInWater() && !((AbstractSchoolingThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
        }
        this.body_back.yRot = -backRotation * 0.2f * Mth.sin((float)(backRotSpeed * 0.65f * ageInTicks));
        this.body_back_2.yRot = -backRotation * 0.3f * Mth.sin((float)(backRotSpeed * 0.65f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.main.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 1.25f;
        poseStack.scale(scale, scale + 0.5f, scale);
        poseStack.translate(0.0f, -0.375f, -0.125f);
    }
}

