/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.ResourceKeyHolder;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.util.List;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;

public class FOTItemProperties {
    private static final List<Item> FISH_ITEMS = List.of(FOTItems.SPLASHTAIL, FOTItems.PONDIE, FOTItems.ISLEHOPPER, FOTItems.ANCIENTSCALE, FOTItems.PLENTIFIN, FOTItems.WILDSPLASH, FOTItems.DEVILFISH, FOTItems.BATTLEGILL, FOTItems.WRECKER, FOTItems.STORMFISH);
    private static final List<Item> BUCKET_ITEMS = List.of(FOTItems.SPLASHTAIL_BUCKET, FOTItems.PONDIE_BUCKET, FOTItems.ISLEHOPPER_BUCKET, FOTItems.ANCIENTSCALE_BUCKET, FOTItems.PLENTIFIN_BUCKET, FOTItems.WILDSPLASH_BUCKET, FOTItems.DEVILFISH_BUCKET, FOTItems.BATTLEGILL_BUCKET, FOTItems.WRECKER_BUCKET, FOTItems.STORMFISH_BUCKET);

    public static void register() {
        FOTItemProperties.createItemProperties(FISH_ITEMS, (DataComponentType<CustomData>)DataComponents.CUSTOM_DATA);
        FOTItemProperties.createItemProperties(BUCKET_ITEMS, (DataComponentType<CustomData>)DataComponents.BUCKET_ENTITY_DATA);
    }

    private static void createItemProperties(List<Item> items, DataComponentType<CustomData> dataComponentType) {
        for (Item item : items) {
            if (!(item instanceof ResourceKeyHolder)) {
                return;
            }
            ResourceKeyHolder resourceKeyHolder = (ResourceKeyHolder)item;
            String registryKey = resourceKeyHolder.getResourceKey().location().getPath();
            ItemProperties.register((Item)item, (ResourceLocation)FishOfThieves.id(registryKey), (itemStack, level, livingEntity, seed) -> {
                if (level == null) {
                    return 0.0f;
                }
                CustomData customData = (CustomData)itemStack.getOrDefault(dataComponentType, (Object)CustomData.EMPTY);
                String variant = customData.copyTag().getString(registryKey);
                List<ResourceKey> variantList = level.registryAccess().lookupOrThrow(resourceKeyHolder.getResourceKey()).listElements().sorted(AbstractFishVariant.COMPARATOR).map(Holder.Reference::key).toList();
                for (int i = 0; i < variantList.size(); ++i) {
                    ResourceKey resourceKey = variantList.get(i);
                    if (!variant.equals(resourceKey.location().toString())) continue;
                    return (float)i / 16.0f;
                }
                return 0.0f;
            });
        }
    }
}

