/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BushSpreadable;
import com.stevekung.fishofthieves.block.VerticalLeavesBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TropicalRedFernBlock
extends Block
implements BushSpreadable {
    private static final VoxelShape DOWN_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final VoxelShape UP_AABB = Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TropicalRedFernBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return VerticalLeavesBlock.canVerticalLeavesSurvive(state, level, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)VerticalLeavesBlock.CEILING) != false ? UP_AABB : DOWN_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VerticalLeavesBlock.CEILING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(context.getClickedFace() == Direction.DOWN));
        if (blockState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            return blockState;
        }
        return null;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return BushSpreadable.hasSpreadableNeighbourPos(level, pos, state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BushSpreadable.findSpreadableNeighbourPos((Level)level, pos, state).ifPresent(blockPos -> level.setBlockAndUpdate(blockPos, (BlockState)this.defaultBlockState().setValue((Property)VerticalLeavesBlock.CEILING, (Comparable)((Boolean)state.getValue((Property)VerticalLeavesBlock.CEILING)))));
    }
}

