/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.block.VerticalLeavesBlock;
import com.stevekung.fishofthieves.client.AngledLeavesComponent;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.CauldronUtils;
import com.stevekung.fishofthieves.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BananaLeavesBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final MapCodec<BananaLeavesBlock> CODEC = BananaLeavesBlock.simpleCodec(BananaLeavesBlock::new);
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)1, (int)2);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    public BananaLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.STEM))).setValue(TYPE, (Comparable)((Object)Type.LOWER))).setValue((Property)COUNT, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)COUNT) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)COUNT) < 2) {
            if (state.getValue(PART) == Part.STEM) {
                BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
                level.setBlock(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
            } else {
                BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
                level.setBlock(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isRainingAt(pos.above()) && state.getValue(PART) == Part.TAIL && random.nextFloat() < 0.5f) {
            CauldronUtils.fillCauldronFromLeavesTail(state, level, pos);
        }
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() != null && entityCollisionContext.getEntity().isSwimming()) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, TYPE, WATERLOGGED, COUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(TYPE) == Type.UPPER ? TOP_AABB : BOTTOM_AABB;
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.TAIL ? direction.getOpposite() : direction;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.isRainingAt(pos.above()) && random.nextInt(4) == 0) {
            if (state.getValue(PART) == Part.STEM) {
                double ySpawn = state.getValue(TYPE) == Type.UPPER ? 0.6 : 0.1;
                BlockPos blockPos = pos.below();
                BlockState blockState = level.getBlockState(blockPos);
                if (!blockState.canOcclude() || !blockState.isFaceSturdy((BlockGetter)level, blockPos, Direction.UP)) {
                    double x = (double)pos.getX() + random.nextDouble();
                    double y = (double)pos.getY() + ySpawn;
                    double z = (double)pos.getZ() + random.nextDouble();
                    level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
                }
            } else {
                Direction direction = (Direction)state.getValue((Property)FACING);
                double yOffset = state.getValue(TYPE) == Type.UPPER ? 0.1 : -0.4;
                AngledLeavesComponent component = new AngledLeavesComponent(22.5, 0.85, 60.0);
                ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.of((int)2, (int)6), yOffset, 4, false, true, component);
            }
        }
    }

    private BlockState placeVerticalLeaves(Direction direction, boolean isWater) {
        BlockState blockState = (BlockState)FOTBlocks.VERTICAL_BANANA_LEAVES.defaultBlockState().setValue((Property)VerticalLeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        return direction == Direction.DOWN ? (BlockState)blockState.setValue((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(true)) : blockState;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)COUNT) < 2 || super.canBeReplaced(state, useContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos1;
        BlockPos blockPos;
        Level level = context.getLevel();
        FluidState fluidState = level.getFluidState(blockPos = context.getClickedPos());
        boolean isWater = fluidState.getType() == Fluids.WATER;
        BlockState blockState2 = (BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)Type.LOWER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        Direction direction = context.getClickedFace();
        BlockState blockState = level.getBlockState(context.getClickedPos());
        if (direction.getAxis() == Direction.Axis.Y) {
            if (!blockState.is((Block)this)) {
                return this.placeVerticalLeaves(direction, isWater);
            }
            if (blockState.getValue(PART) == Part.TAIL) {
                BlockPos blockPos12 = blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite());
                level.setBlock(blockPos12, (BlockState)level.getBlockState(blockPos12).setValue((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.getValue((Property)COUNT) + 1))), 2);
            }
            return (BlockState)blockState.setValue((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.getValue((Property)COUNT) + 1)));
        }
        if (blockState.is((Block)this)) {
            if (blockState.getValue(PART) == Part.TAIL) {
                BlockPos blockPos13 = blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite());
                level.setBlock(blockPos13, (BlockState)level.getBlockState(blockPos13).setValue((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.getValue((Property)COUNT) + 1))), 2);
            }
            return (BlockState)blockState.setValue((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.getValue((Property)COUNT) + 1)));
        }
        if ((blockState2 = (BlockState)blockState2.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)level, blockPos) && level.isUnobstructed(blockState2, blockPos1 = blockPos.relative((Direction)blockState2.getValue((Property)FACING)), CollisionContext.empty()) && level.getBlockState(blockPos1).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockPos1)) {
            return context.getClickLocation().y - (double)blockPos.getY() > 0.5 ? (BlockState)blockState2.setValue(TYPE, (Comparable)((Object)Type.UPPER)) : blockState2;
        }
        return null;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        Part part;
        if (!level.isClientSide() && player.isCreative() && (part = (Part)((Object)state.getValue(PART))) == Part.TAIL && (blockState = level.getBlockState(blockPos = pos.relative(BananaLeavesBlock.getNeighbourDirection(part, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue(PART) == Part.STEM) {
            level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
            level.destroyBlock(blockPos, false);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState otherState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        if (otherState.is((Block)this) && otherState.getValue(PART) == Part.STEM) {
            return state.getValue((Property)FACING) == otherState.getValue((Property)FACING);
        }
        return otherState.is(BlockTags.LEAVES) && otherState.isCollisionShapeFullBlock((BlockGetter)level, pos) || otherState.is(FOTTags.Blocks.BANANA_STEMS) || otherState.isFaceSturdy((BlockGetter)level, pos, (Direction)state.getValue((Property)FACING));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
            FluidState fluidState = level.getFluidState(blockPos);
            if (state.is((Block)this) && state.getValue(PART) != Part.TAIL) {
                level.setBlock(blockPos, (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)Part.TAIL))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER)), 3);
            }
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (state.getValue(PART) == Part.STEM) {
            BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
            BlockState blockState = level.getBlockState(blockPos);
            return blockState.is((Block)this) && blockState.getValue(PART) == Part.TAIL ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static enum Part implements StringRepresentable
    {
        STEM("stem"),
        TAIL("tail");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum Type implements StringRepresentable
    {
        UPPER("upper"),
        LOWER("lower");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

