/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BananaBlossomPlantBlock;
import com.stevekung.fishofthieves.block.BananaClusterPlantBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.block.BananaStemBlock;
import com.stevekung.fishofthieves.block.UnderripeBananaClusterPlantBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public class BananaClusterGrowableStemBlock
extends BananaStemBlock
implements BonemealableBlock {
    public BananaClusterGrowableStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isRaining() && level.canSeeSky(pos) && random.nextInt(8) == 0) {
            this.growRandomBananaCluster(level, random, pos);
        }
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FOTBlocks.BANANA_STEM);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return Direction.Plane.HORIZONTAL.stream().anyMatch(direction -> this.canGrowBananaBunch((BlockGetter)level, pos, (Direction)direction));
    }

    @Override
    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(level.isRaining() ? 3 : 4) == 0;
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growRandomBananaCluster(level, random, pos);
    }

    private boolean canGrowBananaBunch(BlockGetter level, BlockPos pos, Direction direction) {
        BlockState leavesState = level.getBlockState(pos.relative(direction));
        if (leavesState.is(FOTBlocks.BANANA_LEAVES)) {
            return leavesState.getValue(BananaLeavesBlock.TYPE) == BananaLeavesBlock.Type.UPPER && level.getBlockState(pos.below().relative(direction)).isAir();
        }
        return false;
    }

    private void growRandomBananaCluster(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction.Plane.HORIZONTAL.shuffledCopy(random).stream().filter(direction -> this.canGrowBananaBunch((BlockGetter)level, pos, (Direction)direction)).findFirst().ifPresent(direction -> BananaClusterGrowableStemBlock.growBananaBlossomOrCluster(direction, (LevelSimulatedReader)level, (TriConsumer<BlockPos, BlockState, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((ServerLevel)level).setBlock(arg_0, arg_1, arg_2)), blockPos -> level.getFluidState(blockPos).getType() == Fluids.WATER, random, pos.below().relative(direction)));
    }

    public static void growBananaBlossomOrCluster(Direction direction, LevelSimulatedReader level, TriConsumer<BlockPos, BlockState, Integer> setBlock, Function<BlockPos, Boolean> isWater, RandomSource random, BlockPos pos) {
        int maxY = BananaClusterGrowableStemBlock.findMaxYBelow(level, pos);
        boolean isSmallCluster = false;
        if (maxY == 1) {
            setBlock.accept((Object)pos, (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos), BananaHangingType.STEM), (Object)3);
        } else {
            int yBottom = 0;
            int randHeight = 1 + random.nextInt(maxY);
            for (int height = 0; height < randHeight; ++height) {
                BlockPos blockPos = pos.below(height);
                Predicate<BlockState> stateAbove = state -> level.isStateAtPosition(blockPos.above(), blockState -> blockState.is(state.getBlock()));
                BlockState banana = BananaClusterGrowableStemBlock.selectBananaState(random);
                banana = BananaClusterGrowableStemBlock.updateBananaHangingState(banana, stateAbove, height);
                isSmallCluster |= banana.hasProperty(UnderripeBananaClusterPlantBlock.HANGING);
                setBlock.accept((Object)blockPos, (Object)((BlockState)((BlockState)banana.setValue((Property)BananaClusterPlantBlock.FACING, (Comparable)direction.getOpposite())).setValue((Property)BananaClusterPlantBlock.WATERLOGGED, (Comparable)isWater.apply(blockPos))), (Object)3);
                yBottom = Math.max(yBottom, height);
            }
            setBlock.accept((Object)pos.below(yBottom), (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos.below(yBottom)), BananaClusterGrowableStemBlock.determineHangingType(yBottom, isSmallCluster)), (Object)3);
        }
    }

    private static BlockState createBlossomState(Direction direction, boolean isWaterlogged, BananaHangingType hangingType) {
        return (BlockState)((BlockState)((BlockState)FOTBlocks.BANANA_BLOSSOM_PLANT.defaultBlockState().setValue((Property)BananaBlossomPlantBlock.FACING, (Comparable)direction.getOpposite())).setValue(BananaBlossomPlantBlock.HANGING, (Comparable)((Object)hangingType))).setValue((Property)BananaBlossomPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    private static BlockState selectBananaState(RandomSource random) {
        return random.nextFloat() < 0.2f ? FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.defaultBlockState() : (random.nextFloat() < 0.4f ? FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.defaultBlockState() : FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.defaultBlockState());
    }

    private static BlockState updateBananaHangingState(BlockState banana, Predicate<BlockState> stateAbove, int i) {
        if (banana.hasProperty(BananaClusterPlantBlock.HANGING)) {
            banana = (BlockState)banana.setValue(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaClusterPlantBlock.HangingType.STEM : BananaClusterPlantBlock.HangingType.NONE)));
            if (stateAbove.test(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.defaultBlockState())) {
                banana = (BlockState)banana.setValue(BananaClusterPlantBlock.HANGING, (Comparable)((Object)BananaClusterPlantBlock.HangingType.SMALL_CLUSTER));
            }
        } else if (banana.hasProperty(UnderripeBananaClusterPlantBlock.HANGING)) {
            boolean isLargeCluster;
            boolean bl = isLargeCluster = stateAbove.test(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.defaultBlockState()) || stateAbove.test(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.defaultBlockState());
            banana = (BlockState)banana.setValue(UnderripeBananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaHangingType.STEM : (isLargeCluster ? BananaHangingType.CLUSTER : BananaHangingType.SMALL_CLUSTER))));
        }
        return banana;
    }

    private static BananaHangingType determineHangingType(int yBottom, boolean isSmallCluster) {
        return yBottom == 0 ? BananaHangingType.STEM : (isSmallCluster ? BananaHangingType.SMALL_CLUSTER : BananaHangingType.CLUSTER);
    }

    private static int findMaxYBelow(LevelSimulatedReader level, BlockPos pos) {
        int maxY;
        for (maxY = 0; level.isStateAtPosition(pos.below(maxY), BlockBehaviour.BlockStateBase::canBeReplaced) && maxY < 6; ++maxY) {
        }
        return maxY;
    }
}

