/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init;

import com.mojang.logging.LogUtils;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.twilightdelight.compat.ThirstCompat;
import dev.xkmc.twilightdelight.init.data.ExtraLootGen;
import dev.xkmc.twilightdelight.init.data.FoodTwilight;
import dev.xkmc.twilightdelight.init.data.GLMGen;
import dev.xkmc.twilightdelight.init.data.LangData;
import dev.xkmc.twilightdelight.init.data.ModFilePackResources;
import dev.xkmc.twilightdelight.init.data.RecipeGen;
import dev.xkmc.twilightdelight.init.data.TDDatapackRegistriesGen;
import dev.xkmc.twilightdelight.init.data.TDDatapackTagsGen;
import dev.xkmc.twilightdelight.init.data.TDModConfig;
import dev.xkmc.twilightdelight.init.data.TagGen;
import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import dev.xkmc.twilightdelight.init.registrate.TDEffects;
import dev.xkmc.twilightdelight.init.registrate.TDItems;
import dev.xkmc.twilightdelight.init.registrate.TDRecipes;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightFood;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightPie;
import dev.xkmc.twilightdelight.util.StoveAddBlockUtil;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;
import twilightforest.init.TFItems;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModEffects;

@Mod(value="twilightdelight")
@EventBusSubscriber(modid="twilightdelight", bus=EventBusSubscriber.Bus.MOD)
public class TwilightDelight {
    public static final String MODID = "twilightdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Reg REG = new Reg("twilightdelight");
    public static final L2Registrate REGISTRATE = new L2Registrate("twilightdelight");

    public TwilightDelight() {
        TDBlocks.register();
        TDItems.register();
        DelightFood.register();
        DelightPie.register();
        TDEffects.register();
        TDRecipes.register();
        TDModConfig.init();
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StoveAddBlockUtil.addBlock((BlockEntityType)ModBlockEntityTypes.STOVE.get(), (Block)TDBlocks.MAZE_STOVE.get());
            StoveAddBlockUtil.addBlock((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get(), (Block)TDBlocks.FIERY_POT.get());
            LinkedHashSet<Block> set = new LinkedHashSet<Block>(((BlockEntityType)ModBlockEntityTypes.CABINET.get()).validBlocks);
            for (TDBlocks.WoodTypes e : TDBlocks.WoodTypes.values()) {
                set.add((Block)TDBlocks.CABINETS[e.ordinal()].get());
            }
            ((BlockEntityType)ModBlockEntityTypes.CABINET.get()).validBlocks = set;
            if (ModList.get().isLoaded("thirst")) {
                ThirstCompat.init();
            }
        });
    }

    @SubscribeEvent
    public static void modifyDefaultComponent(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)TFItems.MEEF_STROGANOFF, b -> b.set(DataComponents.FOOD, (Object)new FoodProperties.Builder().nutrition(8).saturationModifier(0.6f).alwaysEdible().usingConvertsTo((ItemLike)Items.BOWL).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000), 1.0f).build()));
        if (((Boolean)Configuration.ENABLE_STACKABLE_SOUP_ITEMS.get()).booleanValue()) {
            event.modify((ItemLike)TFItems.MEEF_STROGANOFF, b -> b.set(DataComponents.MAX_STACK_SIZE, (Object)16));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::genItemTag);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::genBlockTag);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipes);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, ExtraLootGen::genLoot);
        REGISTRATE.addDataGenerator(L2TagGen.EFF_TAGS, pvd -> pvd.addTag(L2TagGen.TRACKED_EFFECTS).add((Object[])new MobEffect[]{(MobEffect)TDEffects.FIRE_RANGE.get(), (MobEffect)TDEffects.FROZEN_RANGE.get(), (MobEffect)TDEffects.POISON_RANGE.get(), (MobEffect)TDEffects.AURORA_GLOWING.get()}));
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, pvd -> pvd.builder(NeoForgeDataMaps.COMPOSTABLES).add((Holder)TDBlocks.MUSHGLOOM_COLONY.getSibling(Registries.ITEM), (Object)new Compostable(1.0f), false, new ICondition[0]));
        DataGenerator gen = event.getGenerator();
        CompletableFuture pvd2 = event.getLookupProvider();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper file = event.getExistingFileHelper();
        boolean run = event.includeServer();
        gen.addProvider(run, (DataProvider)new GLMGen(output, pvd2));
        gen.addProvider(run, (DataProvider)new FoodTwilight(gen, pvd2));
        TDDatapackRegistriesGen reg = new TDDatapackRegistriesGen(output, pvd2);
        gen.addProvider(run, (DataProvider)reg);
        gen.addProvider(run, (DataProvider)new TDDatapackTagsGen(output, reg.getRegistryProvider(), file));
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                return;
            }
            String builtin = "shader_compatible_fiery";
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("twilightdelight:" + builtin, (Component)Component.literal((String)"Shader Compatible Fiery"), PackSource.FEATURE, Optional.empty()), (Pack.ResourcesSupplier)new ModFilePackResources(modFile, "resourcepacks/" + builtin), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

