/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.tile.VendingMachineBlockEntityBase;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendingMachineBlockEntity
extends VendingMachineBlockEntityBase {
    private EnumMap<Direction, IItemHandler> itemCaps = new EnumMap(Direction.class);
    private InvWrapper inputWr = new InvWrapper((Container)this.getInputs());
    private InvWrapper outputWr = new InvWrapper((Container)this.getOutputs());
    private EnumMap<Direction, BlockCapabilityCache<IItemHandler, Direction>> sideCache = new EnumMap(Direction.class);

    public VendingMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        for (Direction d : Direction.values()) {
            this.itemCaps.put(d, new Handler(d));
        }
    }

    public IItemHandler getInventory(@Nullable Direction side) {
        return this.itemCaps.get(side);
    }

    public void pullItemsFrom(BlockPos relative, Direction opposite) {
        IItemHandler cap = this.getHandler(relative, opposite);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack ins;
                ItemStack ex;
                ItemStack item = cap.getStackInSlot(i);
                if (!this.canInputItem(item) || (ex = cap.extractItem(i, item.getCount(), true)).isEmpty() || !(ins = this.attempInsert(ex, (IItemHandler)this.inputWr, true)).isEmpty() && ins.getCount() == ex.getCount()) continue;
                ex = cap.extractItem(i, item.getCount() - ins.getCount(), false);
                ins = this.attempInsert(ex, (IItemHandler)this.inputWr, false);
                return;
            }
        }
    }

    private ItemStack attempInsert(ItemStack stack, IItemHandler d, boolean simulate) {
        ItemStack is = stack.copy();
        for (int i = 0; i < d.getSlots(); ++i) {
            ItemStack res = d.insertItem(i, is, simulate);
            if (res.isEmpty()) {
                return ItemStack.EMPTY;
            }
            res = is;
        }
        return is;
    }

    public void pushItemsTo(BlockPos relative, Direction opposite) {
        IItemHandler cap = this.getHandler(relative, opposite);
        if (cap != null) {
            for (int i = 0; i < this.outputWr.getSlots(); ++i) {
                ItemStack ins;
                ItemStack item = this.outputWr.getStackInSlot(i);
                if (item.isEmpty() || !(ins = this.attempInsert(item, cap, true)).isEmpty() && ins.getCount() == item.getCount()) continue;
                ItemStack ex = this.outputWr.extractItem(i, item.getCount() - ins.getCount(), false);
                ins = this.attempInsert(ex, cap, false);
                return;
            }
        }
    }

    private IItemHandler getHandler(BlockPos relative, Direction d) {
        return (IItemHandler)this.sideCache.computeIfAbsent(d, __ -> BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)relative, (Object)d, () -> !this.isRemoved(), () -> {})).getCapability();
    }

    public class Handler
    implements IItemHandler {
        private final Direction dir;

        public Handler(Direction dir) {
            this.dir = dir;
        }

        public int getSlots() {
            return VendingMachineBlockEntity.this.inputWr.getSlots() + VendingMachineBlockEntity.this.outputWr.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return slot < VendingMachineBlockEntity.this.inputWr.getSlots() ? VendingMachineBlockEntity.this.inputWr.getStackInSlot(slot) : VendingMachineBlockEntity.this.outputWr.getStackInSlot(slot - VendingMachineBlockEntity.this.inputWr.getSlots());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot >= VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canInput(stack, this.dir)) {
                return stack;
            }
            return VendingMachineBlockEntity.this.inputWr.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canOutput(this.dir)) {
                return ItemStack.EMPTY;
            }
            return VendingMachineBlockEntity.this.outputWr.extractItem(slot - VendingMachineBlockEntity.this.inputWr.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot < VendingMachineBlockEntity.this.inputWr.getSlots() && VendingMachineBlockEntity.this.canInput(stack, this.dir);
        }
    }
}

