/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class OwnableBlockEntity
extends BlockEntity {
    private String ownerNameCache;
    private UUID owner;

    public OwnableBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void setOwner(Player p) {
        this.ownerNameCache = p.getScoreboardName();
        this.owner = p.getUUID();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        if (this.ownerNameCache != null) {
            pTag.putString("ownerNameCache", this.ownerNameCache);
        }
        if (this.owner != null) {
            pTag.putUUID("owner", this.owner);
        }
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.ownerNameCache = pTag.contains("ownerNameCache", 8) ? pTag.getString("ownerNameCache") : null;
        this.owner = pTag.hasUUID("owner") ? pTag.getUUID("owner") : null;
    }

    public boolean canAccess(Player p) {
        return p.getUUID().equals(this.owner);
    }

    public String getOwnerNameCache() {
        return this.ownerNameCache;
    }
}

