/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.screen.widget;

import com.tom.trading.screen.widget.EnumCycleButton;
import com.tom.trading.screen.widget.IOMode;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.ComponentJoiner;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IOSideModeButton
extends EnumCycleButton<IOMode> {
    private static final ResourceLocation AUTO_INPUT = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/side_input_auto");
    private static final ResourceLocation AUTO_OUTPUT = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/side_output_auto");
    private static final ResourceLocation AUTO_IO = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/side_io_auto");
    private boolean autoMode;
    private Listener sendUpdate;
    private BlockFaceDirection side;

    public IOSideModeButton(int x, int y, BlockFaceDirection side, Listener sendUpdate) {
        super(x, y, (Component)Component.translatable((String)""), "side", (Enum[])IOMode.values(), (b, m) -> {
            b.setState(m);
            ((IOSideModeButton)((Object)b)).send();
        });
        this.sendUpdate = sendUpdate;
        this.side = side;
    }

    public void onPress() {
        if (Screen.hasShiftDown()) {
            this.autoMode = !this.autoMode;
            this.send();
        } else {
            super.onPress();
        }
    }

    private void send() {
        this.sendUpdate.set(this.side, (IOMode)((Object)this.getState()), this.autoMode);
    }

    @Override
    public ResourceLocation getIcon() {
        if (this.autoMode) {
            switch ((IOMode)((Object)this.getState())) {
                case INPUT: {
                    return AUTO_INPUT;
                }
                case IO: {
                    return AUTO_IO;
                }
                case OUTPUT: {
                    return AUTO_OUTPUT;
                }
            }
        }
        return super.getIcon();
    }

    public void setAutoMode(boolean autoMode) {
        this.autoMode = autoMode;
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.setTooltip(Tooltip.create((Component)Stream.of(Component.translatable((String)("tooltip.toms_trading_network.side." + this.side.name().toLowerCase(Locale.ROOT))), Component.translatable((String)("tooltip.toms_trading_network.side_config." + ((IOMode)((Object)this.getState())).name().toLowerCase(Locale.ROOT))), Component.translatable((String)("tooltip.toms_trading_network.side_config_auto." + (this.autoMode ? "on" : "off")))).collect(ComponentJoiner.joining((Component)Component.empty(), (Component)Component.literal((String)"\n")))));
    }

    @Override
    public void setState(IOMode state) {
        if (state == IOMode.OFF) {
            this.autoMode = false;
        }
        super.setState(state);
        this.updateTooltip();
    }

    public static interface Listener {
        public void set(BlockFaceDirection var1, IOMode var2, boolean var3);
    }
}

