/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.screen.widget;

import com.tom.trading.screen.widget.IconButton;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class EnumCycleButton<T extends Enum<T>>
extends IconButton {
    private T state;
    public Function<T, Tooltip> tooltipFactory;
    public Function<T, ResourceLocation> icon = e -> ResourceLocation.tryBuild((String)"toms_trading_network", (String)("icons/" + prefix + "_" + e.name().toLowerCase(Locale.ROOT)));

    public EnumCycleButton(int x, int y, Component name, String prefix, T[] el, BiConsumer<EnumCycleButton<T>, T> stateUpdate) {
        super(x, y, name, null, EnumCycleButton.onPress(el, stateUpdate));
    }

    protected MutableComponent createNarrationMessage() {
        return EnumCycleButton.wrapDefaultNarrationMessage((Component)this.name.copy().append(" ").append((Component)Component.translatable((String)("narrator.toms_storage.button_state." + ((Enum)this.state).name().toLowerCase(Locale.ROOT)))));
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon.apply(this.state);
    }

    public void setState(T state) {
        if (this.state != state && this.tooltipFactory != null) {
            this.setTooltip(this.tooltipFactory.apply(state));
        }
        this.state = state;
    }

    public T getState() {
        return this.state;
    }

    private static <T extends Enum<T>> Button.OnPress onPress(T[] el, BiConsumer<EnumCycleButton<T>, T> stateUpdate) {
        return b -> {
            EnumCycleButton v = (EnumCycleButton)b;
            stateUpdate.accept(v, el[(((Enum)v.getState()).ordinal() + el.length + (Screen.hasAltDown() ? -1 : 1)) % el.length]);
        };
    }
}

