/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.screen;

import com.tom.trading.Content;
import com.tom.trading.menu.VendingMachineConfigMenu;
import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.screen.AbstractFilteredScreen;
import com.tom.trading.screen.widget.IOMode;
import com.tom.trading.screen.widget.IOSideModeButton;
import com.tom.trading.screen.widget.ToggleButton;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.PopupMenuManager;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VendingMachineConfigScreen
extends AbstractFilteredScreen<VendingMachineConfigMenu> {
    private static final ResourceLocation gui = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"textures/gui/vending_machine_config.png");
    private static final ResourceLocation tagBg = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/tag_filter_bg");
    private EditBox nameBox;
    private Component title;
    private EnumMap<BlockFaceDirection, IOSideModeButton> sideCfgButtons = new EnumMap(BlockFaceDirection.class);
    private PopupMenuManager popup = new PopupMenuManager((Screen)this);
    private ToggleButton creativeBtn;

    public VendingMachineConfigScreen(VendingMachineConfigMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.title = pTitle;
        pMenu.updateGui = this::updateGui;
    }

    protected void renderBg(GuiGraphics gr, float pPartialTick, int pMouseX, int pMouseY) {
        gr.blit(gui, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        for (int i = 0; i < 8; ++i) {
            Slot s = ((VendingMachineConfigMenu)this.menu).getSlot(i);
            if (s.getItem().isEmpty() || (((VendingMachineConfigMenu)this.menu).matchNBT & 1 << i) != 0 && s.getItem().getItem() != Content.TAG_FILTER.get()) continue;
            gr.blitSprite(tagBg, this.leftPos + s.x - 1, this.topPos + s.y - 1, 18, 18);
        }
        gr.blit(this.leftPos + 134, this.topPos + 46, 0, 16, 16, this.minecraft.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"toms_trading_network", (String)"block/vending_machine_front")));
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 211;
        this.inventoryLabelY = this.imageHeight - 92;
        this.sideCfgButtons.clear();
        super.init();
        this.nameBox = new EditBox(this.font, this.leftPos + 7, this.topPos + 7, 110, 16, (Component)Component.translatable((String)"narrator.toms_trading_network.vending_machine_name"));
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.nameBox.setValue(this.title.getString());
        this.nameBox.setResponder(this::onNameChanged);
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            IOSideModeButton btn = new IOSideModeButton(this.leftPos + 118 + d.getX() * 16, this.topPos + 30 + d.getY() * 16, d, ((VendingMachineConfigMenu)this.menu)::setSides);
            this.sideCfgButtons.put(d, btn);
            this.addRenderableWidget((GuiEventListener)btn);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.toms_trading_network.vending_machine.open_trading"), b -> this.sendButtonClick(64)).bounds(this.leftPos + 120, this.topPos + 7, 50, 20).build());
        this.creativeBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos + this.imageWidth - 18, this.topPos - 18).name((Component)Component.translatable((String)"narrator.toms_trading_network.vending_machine.creative_mode")).iconOff(ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/creative_off")).iconOn(ResourceLocation.tryBuild((String)"toms_trading_network", (String)"icons/creative_on")).build(s -> this.sendButtonClick(0x20 | (s ? 1 : 0))));
        this.creativeBtn.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.toms_trading_network.creative_mode.off")), Tooltip.create((Component)Component.translatable((String)"tooltip.toms_trading_network.creative_mode.on")));
        if (this.minecraft.player.getAbilities().instabuild) {
            this.addRenderableWidget((GuiEventListener)this.creativeBtn);
        }
        this.updateGui();
    }

    private void onNameChanged(String name) {
        ((VendingMachineConfigMenu)this.menu).setName(name);
        this.title = Component.literal((String)name);
    }

    private void sendMatchNBT(int slot, boolean config) {
        this.sendButtonClick(0x60 | (config ? 16 : 0) | slot & 0xF);
    }

    private void sendButtonClick(int pPageData) {
        this.minecraft.gameMode.handleInventoryButtonClick(((VendingMachineConfigMenu)this.menu).containerId, pPageData);
    }

    public void render(GuiGraphics gr, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(gr, pMouseX, pMouseY, pPartialTick);
        if (this.popup.render(gr, this.font, pMouseX, pMouseY)) {
            this.renderTooltip(gr, pMouseX, pMouseY);
        }
    }

    protected void renderLabels(GuiGraphics gr, int pMouseX, int pMouseY) {
        gr.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        gr.drawString(this.font, (Component)Component.translatable((String)"label.toms_trading_network.vending_machine.cost"), this.inventoryLabelX, 26, 0x404040, false);
        gr.drawString(this.font, (Component)Component.translatable((String)"label.toms_trading_network.vending_machine.result"), 76, 26, 0x404040, false);
        gr.drawString(this.font, (Component)Component.translatable((String)"label.toms_trading_network.vending_machine.input"), this.inventoryLabelX, 72, 0x404040, false);
        gr.drawString(this.font, (Component)Component.translatable((String)"label.toms_trading_network.vending_machine.output"), 98, 72, 0x404040, false);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.popup.mouseClick(pMouseX, pMouseY, pButton)) {
            return true;
        }
        Slot clicked = this.getSlotUnderMouse();
        if (pButton == 1 && clicked instanceof PhantomSlot && !clicked.getItem().isEmpty()) {
            int popupSlot = clicked.getContainerSlot();
            boolean tagFilter = clicked.getItem().getItem() == Content.TAG_FILTER.get();
            List tags = clicked.getItem().getTags().toList();
            this.nameBox.setFocused(false);
            this.popup.open(pMouseX, pMouseY, new PopupMenuManager.TextFieldElement(() -> Component.translatable((String)"tooltip.toms_trading_network.item_count"), s -> {
                try {
                    int c = Integer.parseInt(s);
                    ((VendingMachineConfigMenu)this.menu).setConfigCount(clicked, c);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }, this.font, Integer.toString(clicked.getItem().getCount())), new PopupMenuManager.ButtonElement(() -> tagFilter ? Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{CommonComponents.GUI_NO}).withStyle(ChatFormatting.DARK_GRAY)) : Component.translatable((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{(((VendingMachineConfigMenu)this.menu).matchNBT & 1 << popupSlot) != 0 ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), () -> {
                ((VendingMachineConfigMenu)this.menu).matchNBT ^= 1 << popupSlot;
                this.sendMatchNBT(popupSlot, (((VendingMachineConfigMenu)this.menu).matchNBT & 1 << popupSlot) != 0);
            }), new PopupMenuManager.ButtonElement(() -> tagFilter || tags.isEmpty() ? Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.toms_trading_network.to_tag_filter").withStyle(ChatFormatting.DARK_GRAY)) : Component.translatable((String)"tooltip.toms_trading_network.to_tag_filter"), () -> {
                if (!tags.isEmpty()) {
                    this.popup.replace((PopupMenuManager.PopupElement[])tags.stream().map(s -> new PopupMenuManager.ButtonElement(() -> Component.literal((String)s.location().toString()), () -> {
                        ItemStack st = new ItemStack((ItemLike)Content.TAG_FILTER.get(), clicked.getItem().getCount());
                        st.applyComponents(DataComponentPatch.builder().set(Content.TAG_COMPONENT.get(), s).build());
                        ((VendingMachineConfigMenu)this.menu).setPhantom(clicked, st);
                        this.popup.close();
                    })).toArray(PopupMenuManager.PopupElement[]::new));
                }
            }));
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.popup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            if (this.nameBox.isFocused()) {
                this.nameBox.setFocused(false);
            } else {
                this.minecraft.player.closeContainer();
            }
            return true;
        }
        if (pKeyCode == 258) {
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        return !this.nameBox.keyPressed(pKeyCode, pScanCode, pModifiers) && !this.nameBox.canConsumeInput() ? super.keyPressed(pKeyCode, pScanCode, pModifiers) : true;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.popup.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    private void updateGui() {
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            IOSideModeButton b = this.sideCfgButtons.get((Object)d);
            b.setState(this.getFacingState(d));
            b.setAutoMode(this.isAuto(d));
        }
        this.creativeBtn.setState(((VendingMachineConfigMenu)this.menu).creativeMode != 0);
    }

    private IOMode getFacingState(BlockFaceDirection d) {
        boolean output;
        boolean input = (((VendingMachineConfigMenu)this.menu).inputCfg & 1 << d.ordinal()) != 0;
        boolean bl = output = (((VendingMachineConfigMenu)this.menu).outputCfg & 1 << d.ordinal()) != 0;
        if (input && output) {
            return IOMode.IO;
        }
        if (input) {
            return IOMode.INPUT;
        }
        if (output) {
            return IOMode.OUTPUT;
        }
        return IOMode.OFF;
    }

    private boolean isAuto(BlockFaceDirection d) {
        return (((VendingMachineConfigMenu)this.menu).autoCfg & 1 << d.ordinal()) != 0;
    }
}

