/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.menu;

import com.tom.trading.Content;
import com.tom.trading.menu.AbstractFilteredMenu;
import com.tom.trading.menu.VendingMachineTradingMenu;
import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.screen.widget.IOMode;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.DataSlots;
import com.tom.trading.util.IDataReceiver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VendingMachineConfigMenu
extends AbstractFilteredMenu
implements IDataReceiver {
    private VendingMachineBlockEntityBase machine;
    protected final Inventory pinv;
    public int inputCfg;
    public int outputCfg;
    public int autoCfg;
    public int matchNBT;
    public int creativeMode;
    public Runnable updateGui;

    public VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(9), (Container)new SimpleContainer(9), (Container)new SimpleContainer(8));
        this.addDataSlot(DataSlots.set(c -> {
            this.inputCfg = c;
        }).onUpdate(this::updateGui));
        this.addDataSlot(DataSlots.set(c -> {
            this.outputCfg = c;
        }).onUpdate(this::updateGui));
        this.addDataSlot(DataSlots.set(c -> {
            this.matchNBT = c;
        }));
        this.addDataSlot(DataSlots.set(c -> {
            this.autoCfg = c;
        }).onUpdate(this::updateGui));
        this.addDataSlot(DataSlots.set(c -> {
            this.creativeMode = c;
        }).onUpdate(this::updateGui));
    }

    public VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory, VendingMachineBlockEntityBase machine) {
        this(pContainerId, pPlayerInventory, (Container)machine.getInputs(), (Container)machine.getOutputs(), (Container)machine.getConfig());
        this.machine = machine;
        this.addDataSlot(DataSlots.get(machine::getInputSides));
        this.addDataSlot(DataSlots.get(machine::getOutputSides));
        this.addDataSlot(DataSlots.get(machine::getMatchNBT));
        this.addDataSlot(DataSlots.get(machine::getAutoSides));
        this.addDataSlot(DataSlots.get(() -> machine.isCreativeMode() ? 1 : 0));
    }

    private VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory, Container input, Container output, final Container config) {
        super(Content.VENDING_MACHINE_CONFIG_MENU.get(), pContainerId, pPlayerInventory);
        int j;
        int i;
        this.pinv = pPlayerInventory;
        for (i = 0; i < 4; ++i) {
            this.addSlot(new PhantomSlot(config, i, 8 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new PhantomSlot(config, i + 4, 76 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new Slot(input, j + i * 4, 8 + j * 18, 82 + i * 18){

                    public boolean mayPlace(ItemStack pStack) {
                        for (int i = 0; i < 4; ++i) {
                            ItemStack o = config.getItem(i + 4).copy();
                            if (!VendingMachineConfigMenu.this.compareItemStack(o, pStack, i + 4)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new Slot(this, output, j + i * 4, 98 + j * 18, 82 + i * 18){

                    public boolean mayPlace(ItemStack pStack) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 187));
        }
    }

    public boolean compareItemStack(ItemStack pStack, ItemStack pOther, int slot) {
        if ((this.matchNBT & 1 << slot) != 0) {
            return ItemStack.isSameItemSameComponents((ItemStack)pStack, (ItemStack)pOther);
        }
        return ItemStack.isSameItem((ItemStack)pStack, (ItemStack)pOther);
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot instanceof PhantomSlot) {
            slot.set(ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex >= 8 && pIndex < 26) {
                if (!this.moveItemStackTo(itemstack1, 26, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (pIndex >= 26) {
                boolean in = false;
                for (int i = 0; i < 4; ++i) {
                    ItemStack o = ((Slot)this.slots.get(i + 4)).getItem().copy();
                    if (!this.compareItemStack(o, slot.getItem(), i + 4)) continue;
                    in = true;
                    break;
                }
                if (!in) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, 8, 17, false)) {
                    return ItemStack.EMPTY;
                }
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return this.machine != null ? this.machine.isInRange(pPlayer) && this.machine.canAccess(pPlayer) : true;
    }

    @Override
    public void clicked(int slotId, int dragType, ClickType pClickType, Player pPlayer) {
        Slot slot;
        Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            slot.set(this.getCarried().copy());
            return;
        }
        super.clicked(slotId, dragType, pClickType, pPlayer);
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (pId == 64) {
            pPlayer.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                    return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, VendingMachineConfigMenu.this.machine);
                }

                public Component getDisplayName() {
                    return VendingMachineConfigMenu.this.machine.getDisplayName();
                }
            });
            return true;
        }
        if ((pId & 0xE0) == 32) {
            if (pPlayer.getAbilities().instabuild) {
                this.machine.setCreativeMode((pId & 1) != 0);
            }
        } else if ((pId & 0x60) == 96) {
            int slot = pId & 0xF;
            boolean c = (pId & 0x10) != 0;
            this.machine.setMatchNBT(slot, c);
            return true;
        }
        return false;
    }

    @Override
    public void receive(CompoundTag tag) {
        Slot slot;
        int slotId;
        CompoundTag t;
        if (this.pinv.player.isSpectator()) {
            return;
        }
        if (tag.contains("setItemCount")) {
            t = tag.getCompound("setItemCount");
            slotId = t.getInt("id");
            byte count = t.getByte("count");
            Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
            if (slot instanceof PhantomSlot) {
                ItemStack s = slot.getItem().copy();
                s.setCount(Mth.clamp((int)count, (int)1, (int)s.getMaxStackSize()));
                slot.set(s);
            }
        }
        if (tag.contains("setName")) {
            this.machine.setCustomName((Component)Component.literal((String)tag.getString("setName")));
        }
        if (tag.contains("setPhantom")) {
            t = tag.getCompound("setPhantom");
            slotId = t.getInt("id");
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)this.pinv.player.registryAccess(), (CompoundTag)t.getCompound("item"));
            Slot slot3 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
            if (slot instanceof PhantomSlot && !item.isEmpty()) {
                item.setCount(1);
                slot.set(item);
            }
        }
        if (tag.contains("setSide")) {
            byte side = tag.getByte("setSide");
            byte mode = tag.getByte("mode");
            boolean auto = tag.getBoolean("auto");
            this.machine.setSides(side, mode, auto);
        }
    }

    public void setConfigCount(Slot slot, int count) {
        CompoundTag tag = new CompoundTag();
        CompoundTag t = new CompoundTag();
        tag.put("setItemCount", (Tag)t);
        t.putInt("id", slot.index);
        t.putByte("count", (byte)count);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.putString("setName", name);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setSides(BlockFaceDirection dir, IOMode newState, boolean auto) {
        CompoundTag tag = new CompoundTag();
        tag.putByte("setSide", (byte)dir.ordinal());
        tag.putByte("mode", (byte)newState.ordinal());
        tag.putBoolean("auto", auto);
        NetworkHandler.sendDataToServer(tag);
    }

    private void updateGui() {
        if (this.updateGui != null) {
            this.updateGui.run();
        }
    }
}

