/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.jei;

import com.tom.trading.menu.AbstractFilteredMenu;
import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.screen.AbstractFilteredScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class JeiGhostIngredientHandler
implements IGhostIngredientHandler<AbstractFilteredScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractFilteredScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
            for (Slot slot : gui.getMenu().slots) {
                if (!(slot instanceof PhantomSlot)) continue;
                targets.add(new SlotTarget(gui, slot));
            }
            return targets;
        }
        return Collections.emptyList();
    }

    public void onComplete() {
    }

    private static class SlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private Slot slot;
        private Rect2i area;
        private AbstractFilteredScreen gui;

        public SlotTarget(AbstractFilteredScreen gui, Slot slot) {
            this.slot = slot;
            this.gui = gui;
            this.area = new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(ItemStack ingredient) {
            ((AbstractFilteredMenu)this.gui.getMenu()).setPhantom(this.slot, ingredient);
        }
    }
}

