/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.jade;

import com.tom.trading.jade.JadePlugin;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.util.BasicContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum VendingMachineProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return JadePlugin.VENDING_MACHINE;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        VendingMachineBlockEntity te = (VendingMachineBlockEntity)accessor.getBlockEntity();
        data.put("config", (Tag)te.getConfig().createTag((HolderLookup.Provider)accessor.getLevel().registryAccess()));
        data.putByte("state", (byte)te.getTradingState());
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().contains("config")) {
            BasicContainer c = new BasicContainer(8);
            c.fromTag(accessor.getServerData().getList("config", 10), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            byte state = accessor.getServerData().getByte("state");
            IElementHelper elements = IElementHelper.get();
            if (accessor.showDetails()) {
                ITooltip t = elements.tooltip();
                t.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.cost"));
                for (int i = 0; i < 4; ++i) {
                    ItemStack is = c.getItem(i);
                    if (is.isEmpty()) continue;
                    IElement icon = elements.item(is, 1.0f).size(new Vec2(18.0f, 18.0f)).translate(new Vec2(0.0f, -1.0f));
                    icon.message(null);
                    t.add(icon);
                    is.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                }
                BoxStyle.GradientBorder b = BoxStyle.getTransparent().clone();
                b.borderColor = new int[]{-65536, -65536, -65536, -65536};
                b.borderWidth = 1.0f;
                tooltip.add((IElement)elements.box(t, (BoxStyle)b));
                t = elements.tooltip();
                t.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.result"));
                for (int i = 4; i < 8; ++i) {
                    ItemStack is = c.getItem(i);
                    if (is.isEmpty()) continue;
                    IElement icon = elements.item(is, 1.0f).size(new Vec2(18.0f, 18.0f)).translate(new Vec2(0.0f, -1.0f));
                    icon.message(null);
                    t.add(icon);
                    is.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                }
                b = BoxStyle.getTransparent().clone();
                b.borderColor = new int[]{-16711936, -16711936, -16711936, -16711936};
                b.borderWidth = 1.0f;
                tooltip.add((IElement)elements.box(t, (BoxStyle)b));
            } else {
                tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.cost"));
                tooltip.add((Component)Component.empty());
                for (int i = 0; i < c.getContainerSize(); ++i) {
                    ItemStack is = c.getItem(i);
                    if (!is.isEmpty()) {
                        IElement icon = elements.item(is, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f));
                        tooltip.append(icon);
                    }
                    if (i != 3) continue;
                    tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.result"));
                    tooltip.add((Component)Component.empty());
                }
            }
            if (state == 0) {
                tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.noItems"));
            }
        } else {
            tooltip.append((Component)Component.translatable((String)"jade.toms_trading_network.noServerInfo"));
        }
    }
}

