/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.common.worldgen.GalleonStructure;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;

public class ModCreativeTabs {
    public static final RegSupplier<CreativeModeTab> MOD_TAB = CommonConfigs.General.CREATIVE_TAB.get() == false ? null : RegHelper.registerCreativeModeTab((ResourceLocation)Supplementaries.res("supplementaries"), c -> c.title((Component)Component.translatable((String)"tab.supplementaries.supplementaries")).icon(() -> ModRegistry.GLOBE_ITEM.get().getDefaultInstance()));
    public static final List<Consumer<RegHelper.ItemToTabEvent>> SYNCED_ADD_TO_TABS = new ArrayList<Consumer<RegHelper.ItemToTabEvent>>();

    public static void init() {
        RegHelper.addItemsToTabsRegistration(ModCreativeTabs::registerItemsToTabs);
    }

    public static void registerItemsToTabs(RegHelper.ItemToTabEvent event) {
        WoodType w;
        TabAdder adder = new TabAdder(event);
        ArrayList<Supplier<Item>> sconces = new ArrayList<Supplier<Item>>(ModRegistry.SCONCES);
        sconces.add(ModRegistry.SCONCE_LEVER);
        adder.before((ItemLike)Items.LANTERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sconce", (Supplier[])sconces.toArray(Supplier[]::new));
        if (!CommonConfigs.Tools.STASIS_ENABLED.get().booleanValue()) {
            Holder enchantment = ModEnchantments.STASIS_ENCHANTMENT.getHolder(event.getParameters().holders());
            ItemStack itemStack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, 1));
            event.remove(CreativeModeTabs.TOOLS_AND_UTILITIES, new ItemStack[]{itemStack});
        }
        adder.before((ItemLike)Items.CAMPFIRE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "fire_pit", ModRegistry.FIRE_PIT);
        adder.before((ItemLike)Items.CHAIN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "rope", ModRegistry.ROPE);
        adder.after((ItemLike)Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "end_stone_lamp", ModRegistry.END_STONE_LAMP);
        adder.after((ItemLike)Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "deepslate_lamp", ModRegistry.DEEPSLATE_LAMP);
        adder.after((ItemLike)Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "blackstone_lamp", ModRegistry.BLACKSTONE_LAMP);
        adder.after((ItemLike)Items.PEARLESCENT_FROGLIGHT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "stone_lamp", ModRegistry.STONE_LAMP);
        adder.after((ItemLike)Items.DAMAGED_ANVIL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "pedestal", ModRegistry.PEDESTAL);
        adder.before((ItemLike)Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "blackboard", ModRegistry.BLACKBOARD);
        adder.before((ItemLike)Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "notice_board", ModRegistry.NOTICE_BOARD);
        adder.before((ItemLike)Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "clock_block", ModRegistry.CLOCK_BLOCK);
        adder.before((ItemLike)Items.COMPOSTER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "pulley_block", ModRegistry.PULLEY_BLOCK);
        adder.after((ItemLike)Items.JUKEBOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "speaker_block", ModRegistry.SPEAKER_BLOCK);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "cage", ModRegistry.CAGE);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "globe_sepia", ModRegistry.GLOBE_SEPIA);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "globe", ModRegistry.GLOBE);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "hourglass", ModRegistry.HOURGLASS);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "jar", ModRegistry.JAR);
        adder.after((ItemLike)Items.CAULDRON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "goblet", ModRegistry.GOBLET);
        adder.after((ItemLike)Items.ARMOR_STAND, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "statue", ModRegistry.STATUE);
        adder.after((ItemLike)Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "urn", ModRegistry.URN);
        adder.after((ItemLike)Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "planter", ModRegistry.PLANTER);
        adder.after((ItemLike)Items.FLOWER_POT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flower_box", ModRegistry.FLOWER_BOX);
        adder.after((TagKey<Item>)ItemTags.TRIM_TEMPLATES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "galleon", ModRegistry.BLAST_TRIM_TEMPLATE);
        adder.before((ItemLike)Items.DRAGON_HEAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "enderman_head", ModRegistry.ENDERMAN_SKULL_ITEM);
        adder.after((ItemLike)Items.CREEPER_HEAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "spider_head", ModRegistry.SPIDER_SKULL_ITEM);
        adder.before((ItemLike)Items.SEA_PICKLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "barnacles", ModRegistry.BARNACLES);
        adder.before((ItemLike)Items.BOOKSHELF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "timber_frame", new Supplier[]{ModRegistry.TIMBER_FRAME, ModRegistry.TIMBER_BRACE, ModRegistry.TIMBER_CROSS_BRACE});
        if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
            for (Map.Entry entry : ModRegistry.WAY_SIGN_ITEMS.entrySet()) {
                w = (WoodType)entry.getKey();
                event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> {
                    if (i.is(ItemTags.HANGING_SIGNS)) {
                        Block b = w.getBlockOfThis("hanging_sign");
                        return b != null && i.is(b.asItem());
                    }
                    return false;
                }, new ItemLike[]{(ItemLike)entry.getValue()});
            }
        }
        if (CommonConfigs.Functional.CANNON_BOAT_ENABLED.get().booleanValue()) {
            for (Map.Entry entry : ModRegistry.CANNON_BOAT_ITEMS.entrySet()) {
                w = (WoodType)entry.getKey();
                event.addAfter(CreativeModeTabs.TOOLS_AND_UTILITIES, i -> {
                    if (i.is(ItemTags.CHEST_BOATS)) {
                        Item b = w.getItemOfThis("chest_boat");
                        return b != null && i.is(b);
                    }
                    return false;
                }, new ItemLike[]{(ItemLike)entry.getValue()});
            }
        }
        adder.before((ItemLike)Items.CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "doormat", ModRegistry.DOORMAT);
        adder.before((ItemLike)Items.CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "item_shelf", ModRegistry.ITEM_SHELF);
        HashSet<Item> allCandles = new HashSet<Item>();
        ArrayList<Supplier<ItemLike>> arrayList = new ArrayList<Supplier<ItemLike>>();
        for (Supplier<? extends Block> b : ModRegistry.ALL_CANDLE_HOLDERS) {
            Item i2 = b.get().asItem();
            if (allCandles.contains(i2)) {
                throw new AssertionError((Object)("Duplicate candle holder item in creative tab registration: " + String.valueOf(i2) + "How??"));
            }
            allCandles.add(i2);
            arrayList.add(() -> i2);
        }
        adder.after((TagKey<Item>)ItemTags.CANDLES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "candle_holder", (Supplier[])arrayList.toArray(Supplier[]::new));
        adder.after((TagKey<Item>)ItemTags.CANDLES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "candle_holder", (Supplier[])arrayList.toArray(Supplier[]::new));
        adder.after((ItemLike)Items.ENDER_CHEST, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "safe", ModRegistry.SAFE);
        adder.before((ItemLike)Items.SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sack", ModRegistry.SACK);
        adder.after((ItemLike)Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "trapped_present", (Supplier[])ModRegistry.TRAPPED_PRESENTS.values().toArray(Supplier[]::new));
        adder.after((ItemLike)Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "present", (Supplier[])ModRegistry.PRESENTS.values().toArray(Supplier[]::new));
        adder.after((ItemLike)Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "trapped_present", (Supplier[])ModRegistry.TRAPPED_PRESENTS.values().toArray(Supplier[]::new));
        adder.after((ItemLike)Items.PINK_SHULKER_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "present", (Supplier[])ModRegistry.PRESENTS.values().toArray(Supplier[]::new));
        event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(Items.INFESTED_DEEPSLATE), ModCreativeTabs.makeSpikeItems());
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "fodder", ModRegistry.FODDER);
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "sugar_cube", ModRegistry.SUGAR_CUBE);
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "feather_block", ModRegistry.FEATHER_BLOCK);
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flint_block", ModRegistry.FLINT_BLOCK);
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "gravel_bricks", ModRegistry.SUS_GRAVEL_BRICKS);
        adder.after((ItemLike)Items.INFESTED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "slidy_block", ModRegistry.SLIDY_BLOCK);
        adder.after((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "awning", (Supplier[])ModRegistry.AWNINGS.values().toArray(Supplier[]::new));
        adder.after((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "awning", (Supplier[])ModRegistry.AWNINGS.values().toArray(Supplier[]::new));
        if (CommonConfigs.isEnabled("bunting")) {
            event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(ItemTags.BANNERS), new ItemLike[]{(ItemLike)ModRegistry.BUNTING_BLOCKS.get(DyeColor.WHITE).get()});
            event.addAfter(CreativeModeTabs.COLORED_BLOCKS, i -> i.is(ItemTags.BANNERS), (ItemLike[])ModRegistry.BUNTING_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new));
        }
        if (CommonConfigs.Functional.GALLEONS_ENABLED.get().booleanValue()) {
            adder.after((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flag", () -> GalleonStructure.getGalleonFlag((HolderGetter<BannerPattern>)((HolderGetter)event.getParameters().holders().lookup(Registries.BANNER_PATTERN).get())));
        }
        adder.after((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "flag", (Supplier[])ModRegistry.FLAGS.values().toArray(Supplier[]::new));
        adder.after((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "flag", (Supplier[])ModRegistry.FLAGS.values().toArray(Supplier[]::new));
        adder.before((ItemLike)Items.DISPENSER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "cannon", ModRegistry.CANNON);
        adder.after(i -> i.getItem().components().get(DataComponents.JUKEBOX_PLAYABLE) != null, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "music_disc_heave_ho", ModRegistry.PIRATE_DISC);
        adder.after((ItemLike)Items.LAVA_BUCKET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "lumisene", ModFluids.LUMISENE_BUCKET);
        adder.after((ItemLike)Items.HONEY_BOTTLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "lumisene_bottle", ModFluids.LUMISENE_BOTTLE);
        adder.after((ItemLike)Items.FIREWORK_ROCKET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "confetti_popper", ModRegistry.CONFETTI_POPPER);
        adder.after((ItemLike)Items.TNT_MINECART, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "dispenser_minecart", ModRegistry.DISPENSER_MINECART_ITEM);
        adder.after((ItemLike)Items.REDSTONE_TORCH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "sconce_lever", ModRegistry.SCONCE_LEVER);
        adder.before((ItemLike)Items.LEVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "crank", ModRegistry.CRANK);
        adder.before((ItemLike)Items.PISTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "turn_table", ModRegistry.TURN_TABLE);
        adder.before((ItemLike)Items.PISTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "spring_launcher", ModRegistry.SPRING_LAUNCHER);
        adder.after((ItemLike)Items.NOTE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "speaker_block", ModRegistry.SPEAKER_BLOCK);
        adder.after((ItemLike)Items.HOPPER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "faucet", ModRegistry.FAUCET);
        adder.before((ItemLike)Items.TARGET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "cog_block", ModRegistry.COG_BLOCK);
        adder.before((ItemLike)Items.NOTE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "bellows", ModRegistry.BELLOWS);
        adder.after((ItemLike)Items.OBSERVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "crystal_display", ModRegistry.CRYSTAL_DISPLAY);
        adder.after((ItemLike)Items.OBSERVER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "relayer", ModRegistry.RELAYER);
        adder.after((ItemLike)Items.LIGHTNING_ROD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "wind_vane", ModRegistry.WIND_VANE);
        adder.after((ItemLike)Items.IRON_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "netherite_door", ModRegistry.NETHERITE_DOOR);
        adder.after((ItemLike)Items.IRON_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "gold_door", ModRegistry.GOLD_DOOR);
        adder.after((ItemLike)Items.IRON_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "netherite_trapdoor", ModRegistry.NETHERITE_TRAPDOOR);
        adder.after((ItemLike)Items.IRON_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "gold_trapdoor", ModRegistry.GOLD_TRAPDOOR);
        adder.before((ItemLike)Items.OAK_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "lock_block", ModRegistry.LOCK_BLOCK);
        adder.before((ItemLike)Items.REDSTONE_LAMP, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "redstone_illuminator", ModRegistry.REDSTONE_ILLUMINATOR);
        adder.after((ItemLike)Items.END_CRYSTAL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "cannonball", ModRegistry.CANNONBALL_ITEM);
        adder.after((ItemLike)Items.END_CRYSTAL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "bomb", ModRegistry.BOMB_ITEM, ModRegistry.BOMB_BLUE_ITEM);
        adder.afterML(ModRegistry.BOMB_BLUE_ITEM.get(), (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "oreganized", "bomb", ModRegistry.BOMB_SPIKY_ITEM);
        adder.before((ItemLike)Items.BOW, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "quiver", ModRegistry.QUIVER_ITEM);
        adder.after((ItemLike)Items.CLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "altimeter", ModRegistry.ALTIMETER_ITEM);
        adder.after((ItemLike)Items.MAP, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "slice_map", ModRegistry.SLICE_MAP);
        adder.before((ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gold_door", ModRegistry.GOLD_DOOR);
        adder.before((ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gold_trapdoor", ModRegistry.GOLD_TRAPDOOR);
        adder.after((ItemLike)Items.NETHERITE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "netherite_trapdoor", ModRegistry.NETHERITE_TRAPDOOR);
        adder.after((ItemLike)Items.NETHERITE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "netherite_door", ModRegistry.NETHERITE_DOOR);
        adder.after((ItemLike)Items.SMALL_DRIPLEAF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_WILD);
        adder.after((ItemLike)Items.BEETROOT_SEEDS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_SEEDS_ITEM);
        adder.after((ItemLike)Items.HAY_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "flax", ModRegistry.FLAX_BLOCK);
        adder.after((ItemLike)Items.GRAVEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "raked_gravel", ModRegistry.RAKED_GRAVEL);
        adder.after((ItemLike)Items.PUMPKIN_PIE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy", ModRegistry.CANDY_ITEM);
        adder.after((ItemLike)Items.PUMPKIN_PIE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "pancake", ModRegistry.PANCAKE_ITEM);
        adder.after((ItemLike)Items.NETHER_BRICK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ash_bricks", ModRegistry.ASH_BRICK_ITEM);
        adder.after((ItemLike)Items.GLOW_INK_SAC, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "antique_ink", ModRegistry.ANTIQUE_INK);
        adder.after((ItemLike)Items.WHEAT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "flax", ModRegistry.FLAX_ITEM);
        adder.before((ItemLike)Items.PAPER, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ash", ModRegistry.ASH_BLOCK);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS, "plunderer", ModRegistry.PLUNDERER_SPAWN_EGG_ITEM);
        adder.before((ItemLike)Items.BRICKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "ash_bricks", (Supplier[])ModRegistry.ASH_BRICKS_BLOCKS.values().toArray(Supplier[]::new));
        adder.after((ItemLike)Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gravel_bricks", ModRegistry.SUS_GRAVEL_BRICKS);
        adder.after((ItemLike)Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gravel_bricks", ModRegistry.GRAVEL_BRICKS);
        adder.after((ItemLike)Items.REINFORCED_DEEPSLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "slidy_block", ModRegistry.SLIDY_BLOCK);
        adder.before((ItemLike)Items.FISHING_ROD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "lunch_basket", ModRegistry.LUNCH_BASKET_ITEM);
        adder.after((ItemLike)Items.GUSTER_BANNER_PATTERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "dragon_banner_pattern", ModRegistry.DRAGON_PATTERN);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "wrench", ModRegistry.WRENCH);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "key", ModRegistry.KEY_ITEM);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "slingshot", ModRegistry.SLINGSHOT_ITEM);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "rope_arrow", ModRegistry.ROPE_ARROW_ITEM);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "soap", ModRegistry.SOAP);
        adder.before((ItemLike)Items.FLINT_AND_STEEL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "bubble_blower", () -> {
            ItemStack item = ModRegistry.BUBBLE_BLOWER.get().getDefaultInstance();
            item.set(ModComponents.CHARGES.get(), (Object)((Integer)item.get(ModComponents.MAX_CHARGES.get())));
            return item;
        });
        adder.after(i -> i.getItem() instanceof DyeItem, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "soap", ModRegistry.SOAP);
        adder.after((ItemLike)Items.SPECTRAL_ARROW, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, "rope_arrow", ModRegistry.ROPE_ARROW_ITEM);
        adder.after((ItemLike)Items.LEAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "flute", ModRegistry.FLUTE_ITEM);
        adder.after((ItemLike)Items.MOSSY_STONE_BRICK_WALL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "stone_tile", (Supplier[])ModRegistry.STONE_TILE_BLOCKS.values().toArray(Supplier[]::new));
        adder.after((ItemLike)Items.POLISHED_BLACKSTONE_BRICK_WALL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "blackstone_tile", (Supplier[])ModRegistry.BLACKSTONE_TILE_BLOCKS.values().toArray(Supplier[]::new));
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "lapis_bricks", (Supplier[])ModRegistry.LAPIS_BRICKS_BLOCKS.values().toArray(Supplier[]::new));
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "checker_block", ModRegistry.CHECKER_BLOCK, ModRegistry.CHECKER_SLAB);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "fine_wood", ModRegistry.FINE_WOOD, ModRegistry.FINE_WOOD_STAIRS, ModRegistry.FINE_WOOD_SLAB);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "daub", new Supplier[]{ModRegistry.DAUB});
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "wattle_and_daub", new Supplier[]{ModRegistry.DAUB_FRAME, ModRegistry.DAUB_BRACE, ModRegistry.DAUB_CROSS_BRACE});
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "wicker_fence", ModRegistry.WICKER_FENCE);
        adder.after((ItemLike)Items.IRON_BARS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "gold_bars", ModRegistry.GOLD_BARS);
        adder.after((ItemLike)Items.IRON_BARS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "iron_gate", ModRegistry.IRON_GATE);
        if (CompatHandler.QUARK && QuarkCompat.isGoldBarsOn()) {
            adder.afterML("quark:gold_bars", (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "iron_gate", ModRegistry.GOLD_GATE);
        } else if (CommonConfigs.Building.GOLD_BARS_ENABLED.get().booleanValue()) {
            adder.after((ItemLike)ModRegistry.GOLD_BARS.get().asItem(), (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "iron_gate", ModRegistry.GOLD_GATE);
        }
        adder.before((ItemLike)Items.COAL_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "soap", ModRegistry.SOAP_BLOCK);
        adder.before((ItemLike)Items.OAK_FENCE_GATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, "iron_gate", ModRegistry.IRON_GATE);
        adder.after((ItemLike)Items.ARMOR_STAND, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "hat_stand", ModRegistry.HAT_STAND);
        CompatHandler.addItemsToTabs(event);
        SYNCED_ADD_TO_TABS.forEach(o -> o.accept(event));
    }

    private static ItemStack[] makeSpikeItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue()) {
            items.add(ModRegistry.BAMBOO_SPIKES_ITEM.get().getDefaultInstance());
            if (CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue() && CommonConfigs.Functional.TIPPED_SPIKES_TAB.get().booleanValue()) {
                items.add(BambooSpikesTippedItem.createItemStack((Holder<Potion>)Potions.POISON));
                items.add(BambooSpikesTippedItem.createItemStack((Holder<Potion>)Potions.LONG_POISON));
                items.add(BambooSpikesTippedItem.createItemStack((Holder<Potion>)Potions.STRONG_POISON));
                for (Holder.Reference potion : BuiltInRegistries.POTION.holders().toList()) {
                    if (potion == Potions.POISON || potion == Potions.LONG_POISON || potion == Potions.STRONG_POISON || !BambooSpikesTippedItem.isPotionValid(new PotionContents((Holder)potion))) continue;
                    items.add(BambooSpikesTippedItem.createItemStack((Holder<Potion>)potion));
                }
            }
        }
        return (ItemStack[])items.toArray(ItemStack[]::new);
    }

    public static final class TabAdder {
        private final RegHelper.ItemToTabEvent event;
        private final List<ItemStack> uniqueStacksAdded = new ArrayList<ItemStack>();

        public TabAdder(RegHelper.ItemToTabEvent event) {
            this.event = event;
        }

        private void before(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            if (MOD_TAB != null) {
                this.add(tab, items);
                return;
            }
            for (ItemStack stack : items) {
                this.event.addBefore(tab, target, new ItemStack[]{stack});
            }
        }

        private void before(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.before(tab, target, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private void after(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            if (MOD_TAB != null) {
                this.add(tab, items);
                return;
            }
            for (ItemStack stack : items) {
                this.event.addAfter(tab, target, new ItemStack[]{stack});
            }
        }

        private void after(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.after(tab, target, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private void add(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            ResourceKey tabKey = MOD_TAB == null ? tab : MOD_TAB.getKey();
            for (ItemStack stack : items) {
                if (!this.isUnique(stack)) continue;
                this.event.add(tabKey, new ItemStack[]{stack});
            }
        }

        private void add(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.add(tab, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private boolean isUnique(ItemStack stack) {
            Preconditions.checkNotNull((Object)stack);
            Preconditions.checkNotNull((Object)stack.getItem());
            if (MOD_TAB == null) {
                return true;
            }
            for (ItemStack s : this.uniqueStacksAdded) {
                if (s.getItem() != stack.getItem() || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) continue;
                return false;
            }
            this.uniqueStacksAdded.add(stack);
            return true;
        }

        private void after(TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.after((ItemStack i) -> i.is(target), tab, key, items);
        }

        private void after(ItemLike target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.after((ItemStack i) -> i.is(target.asItem()), tab, key, items);
        }

        private void after(Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                Object first = items[0].get();
                if (first instanceof ItemStack) {
                    ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                    this.after(tab, targetPred, entries);
                } else if (first instanceof Collection) {
                    for (Supplier<?> i : items) {
                        if (!(i instanceof Collection)) continue;
                        Collection c = (Collection)((Object)i);
                        ItemLike[] entries = (ItemLike[])c.stream().map(s -> (ItemLike)s).toArray(ItemLike[]::new);
                        this.after(tab, targetPred, entries);
                    }
                } else {
                    ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                    this.after(tab, targetPred, entries);
                }
            }
        }

        private void before(TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.before((ItemStack i) -> i.is(target), tab, key, items);
        }

        private void before(ItemLike target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.before((ItemStack i) -> i.is(target.asItem()), tab, key, items);
        }

        private void before(Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                if (items[0].get() instanceof ItemStack) {
                    ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                    this.before(tab, targetPred, entries);
                } else {
                    ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                    this.before(tab, targetPred, entries);
                }
            }
        }

        private void add(ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                this.add(tab, entries);
            }
        }

        private void afterML(Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
            if (PlatHelper.isModLoaded((String)modLoaded)) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private void afterML(String modTarget, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            ResourceLocation id = ResourceLocation.tryParse((String)modTarget);
            BuiltInRegistries.ITEM.getOptional(id).ifPresent(target -> this.after((ItemLike)target, tab, key, items));
        }

        private void afterTL(Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
            if (TabAdder.isTagOn((String[])tags.toArray(String[]::new))) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private void beforeML(Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
            if (PlatHelper.isModLoaded((String)modLoaded)) {
                this.before((ItemLike)target, tab, key, items);
            }
        }

        private void beforeTL(Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
            if (TabAdder.isTagOn((String[])tags.toArray(String[]::new))) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private static boolean isTagOn(String ... tags) {
            for (String t : tags) {
                if (!BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)t))).isPresent()) continue;
                return true;
            }
            return false;
        }
    }
}

