/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.neoforge;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidStackImpl;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidsUtilImpl {
    public static boolean extractFluidFromTank(BlockEntity tileBack, Direction dir, int amount) {
        IFluidHandler handlerBack = (IFluidHandler)tileBack.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tileBack.getBlockPos(), tileBack.getBlockState(), tileBack, (Object)dir);
        if (handlerBack != null) {
            if (handlerBack.drain(250 * amount, IFluidHandler.FluidAction.SIMULATE).getAmount() != 250 * amount) {
                return false;
            }
            handlerBack.drain(250 * amount, IFluidHandler.FluidAction.EXECUTE);
            tileBack.setChanged();
            return true;
        }
        return false;
    }

    public static Integer fillFluidTank(BlockEntity tileBelow, FluidOffer offer, Direction dir) {
        SoftFluidStackImpl impl;
        FluidStack stack;
        SoftFluidStack softFluidStack;
        IFluidHandler handlerDown = (IFluidHandler)tileBelow.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tileBelow.getBlockPos(), tileBelow.getBlockState(), tileBelow, (Object)dir);
        if (handlerDown != null && (softFluidStack = offer.fluid()) instanceof SoftFluidStackImpl && !(stack = (impl = (SoftFluidStackImpl)softFluidStack).toForgeFluid()).isEmpty()) {
            stack.setAmount(250 * offer.minAmount());
            if (stack.isEmpty()) {
                return null;
            }
            int filled = handlerDown.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            tileBelow.setChanged();
            return Mth.ceil((float)((float)filled / 250.0f));
        }
        return null;
    }

    public static boolean hasFluidHandler(Level level, BlockPos pos, Direction dir) {
        return FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)dir).isPresent();
    }

    @Nullable
    public static FluidOffer getFluidInTank(Level level, BlockPos pos, Direction dir, BlockEntity source) {
        Optional opt = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)dir);
        if (opt.isPresent()) {
            for (int i = 1; i <= 4; ++i) {
                SoftFluidStack forgeFluid;
                int toDrain = i * 250;
                FluidStack fluidInTank = ((IFluidHandler)opt.get()).drain(toDrain, IFluidHandler.FluidAction.SIMULATE);
                if (fluidInTank.isEmpty() || (forgeFluid = SoftFluidStackImpl.fromForgeFluid((FluidStack)fluidInTank)).isEmpty()) continue;
                int actualAmount = fluidInTank.getAmount() / 250;
                return FluidOffer.of(forgeFluid, actualAmount);
            }
        }
        return null;
    }
}

