/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectoryRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CannonBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CannonBoatRenderer
extends BoatRenderer {
    private final Map<WoodType, ResourceLocation> textures = (Map)WoodTypeRegistry.INSTANCE.getValues().stream().collect(ImmutableMap.toImmutableMap(e -> e, t -> Supplementaries.res("textures/entity/cannon_boat/" + t.getTexturePath() + ".png")));
    private static final Map<WoodType, EntityType<?>> woodToEntities = new IdentityHashMap();

    public CannonBoatRenderer(EntityRendererProvider.Context context) {
        super(context, false);
    }

    public ResourceLocation getTextureLocation(Boat entity) {
        WoodType woodType = ((CannonBoatEntity)entity).getWoodType();
        return this.textures.get(woodType);
    }

    public void render(Boat entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        CannonBoatEntity boat = (CannonBoatEntity)entity;
        CannonBlockTile cannon = boat.getInternalCannon();
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)cannon);
        if (renderer == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.getHurtTime() - partialTicks;
        float g = entity.getDamage() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * g / 10.0f * (float)entity.getHurtDir()));
        }
        poseStack.translate(0.0f, -0.375f, 0.0f);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.625f, 0.0f);
        poseStack.scale(4.0f, 4.0f, 4.0f);
        poseStack.mulPose(RotHlpr.Y180);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderStatic(boat.getBannerItem(), ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), 0);
        poseStack.popPose();
        Vec3 offset = boat.getCannonGlobalOffset();
        poseStack.translate(offset.x, offset.y, offset.z);
        CannonBlockTileRenderer.renderCannonModel((CannonBlockTileRenderer)renderer, cannon, partialTicks, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
        CannonTrajectoryRenderer.render(cannon, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, partialTicks);
        poseStack.popPose();
        if (this.entityRenderDispatcher.shouldRenderHitBoxes()) {
            VertexConsumer vc = buffer.getBuffer(RenderType.lines());
            poseStack.pushPose();
            Vec3 p = boat.getCannonGlobalPosition(partialTicks);
            p = p.subtract(boat.position());
            poseStack.translate(p.x, p.y, p.z);
            PoseStack.Pose pose = poseStack.last();
            vc.addVertex(pose, 0.0f, 0.25f, 0.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vc.addVertex(pose, 0.0f, 1.25f, 0.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
            poseStack.popPose();
        }
    }
}

