/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.ConcurrentConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.InvalidModFileException;

public class NightConfigWrapper
implements IConfigurable {
    private final UnmodifiableConfig config;
    private IModFileInfo file;

    public NightConfigWrapper(UnmodifiableConfig config) {
        if (config instanceof ConcurrentConfig) {
            throw new IllegalArgumentException("Cannot create a NightConfigWrapper with a ConcurrentConfig!");
        }
        this.config = config;
    }

    public NightConfigWrapper setFile(IModFileInfo file) {
        this.file = file;
        return this;
    }

    @Override
    public <T> Optional<T> getConfigElement(String ... key) {
        List<String> path = Arrays.asList(key);
        return this.config.getOptional(path).map(value -> {
            ArrayList al;
            if (value instanceof UnmodifiableConfig) {
                return ((UnmodifiableConfig)value).valueMap();
            }
            if (value instanceof ArrayList && (al = (ArrayList)value).size() > 0 && al.get(0) instanceof UnmodifiableConfig) {
                throw new InvalidModFileException("The configuration path " + String.valueOf(path) + " is invalid. I wasn't expecting a multi-object list - remove one of the [[ ]]", this.file);
            }
            return value;
        });
    }

    @Override
    public List<? extends IConfigurable> getConfigList(String ... key) {
        List<String> path = Arrays.asList(key);
        if (this.config.contains(path) && !(this.config.get(path) instanceof Collection)) {
            throw new InvalidModFileException("The configuration path " + String.valueOf(path) + " is invalid. Expecting a collection!", this.file);
        }
        Collection nestedConfigs = (Collection)this.config.getOrElse(path, ArrayList::new);
        return nestedConfigs.stream().map(NightConfigWrapper::new).map(cw -> cw.setFile(this.file)).collect(Collectors.toList());
    }
}

