/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.CardFluidScreen;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LaserGuiGraphicsFluid
extends GuiGraphics {
    public Minecraft minecraft;
    protected final AbstractContainerScreen screen;

    public LaserGuiGraphicsFluid(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource, AbstractContainerScreen screen) {
        super(minecraft, bufferSource);
        this.minecraft = minecraft;
        this.screen = screen;
    }

    private void fillRect(int p_115154_, int p_115155_, int p_115156_, int p_115157_, int p_115158_, int p_115159_, int p_115160_, int p_115161_) {
        Matrix4f matrix4f = this.pose().last().pose();
        VertexConsumer vertexconsumer = this.bufferSource().getBuffer(RenderType.guiOverlay());
        vertexconsumer.addVertex(matrix4f, (float)(p_115154_ + 0), (float)(p_115155_ + 0), 0.0f).setColor(p_115158_, p_115159_, p_115160_, p_115161_);
        vertexconsumer.addVertex(matrix4f, (float)(p_115154_ + 0), (float)(p_115155_ + p_115157_), 0.0f).setColor(p_115158_, p_115159_, p_115160_, p_115161_);
        vertexconsumer.addVertex(matrix4f, (float)(p_115154_ + p_115156_), (float)(p_115155_ + p_115157_), 0.0f).setColor(p_115158_, p_115159_, p_115160_, p_115161_);
        vertexconsumer.addVertex(matrix4f, (float)(p_115154_ + p_115156_), (float)(p_115155_ + 0), 0.0f).setColor(p_115158_, p_115159_, p_115160_, p_115161_);
        this.flush();
    }

    public void renderItemDecorations(Font font, ItemStack itemstack, int x, int y, @Nullable String altText) {
        if (this.shouldRenderFluid(itemstack, x, y, true, false)) {
            CardFluidScreen cardFluidScreen = (CardFluidScreen)this.screen;
            int sloty = (int)Math.floor((y - cardFluidScreen.filterStartY) / 18);
            int slotx = (int)Math.floor((x - cardFluidScreen.filterStartX) / 18);
            int slot = 5 * sloty + slotx;
            ItemStack filter = ((CardFluidScreen)this.screen).filter;
            int totalmbAmt = FilterCount.getSlotAmount(filter, slot);
            int count = FilterCount.getSlotCount(filter, slot);
            int mbAmt = totalmbAmt % 1000;
            PoseStack posestack = this.pose();
            if (count != 0 || mbAmt != 0) {
                String textToDraw = count + "b";
                posestack.pushPose();
                posestack.translate((float)x, (float)y, 200.0f);
                posestack.scale(0.5f, 0.5f, 0.5f);
                if (mbAmt == 0) {
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.5f, 24.0f, 0xFFFFFF, true);
                } else {
                    String textToDraw2 = mbAmt + "mb";
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.5f, 14.0f, 0xFFFFFF, true);
                    this.drawString(font, textToDraw2, 17.0f - (float)font.width(textToDraw2) * 0.5f, 24.0f, 0xFFFFFF, true);
                }
                posestack.popPose();
            }
        } else if (!itemstack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = this.pose();
            if (itemstack.getCount() != 1 || altText != null) {
                String textToDraw = altText == null ? String.valueOf(itemstack.getCount()) : altText;
                posestack.translate(0.0, 0.0, 200.0);
                if (itemstack.getCount() > 99) {
                    posestack.pushPose();
                    posestack.translate((float)x, (float)y, 300.0f);
                    posestack.scale(0.65f, 0.65f, 0.65f);
                    this.drawString(font, textToDraw, 17.0f - (float)font.width(textToDraw) * 0.65f, 17.0f, 0xFFFFFF, true);
                    posestack.popPose();
                } else {
                    this.drawString(font, textToDraw, x + 19 - 2 - font.width(textToDraw), y + 6 + 3, 0xFFFFFF, true);
                }
            }
            if (!this.shouldRenderFluid(itemstack, x, y, true, true)) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.fillRect(x, y, 16, Mth.ceil((float)16.0f), 255, 0, 0, 127);
            }
            if (itemstack.isBarVisible()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                int i = itemstack.getBarWidth();
                int j = itemstack.getBarColor();
                this.fillRect(x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                this.fillRect(x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            }
            float f2 = f = (localplayer = Minecraft.getInstance().player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(itemstack.getItem(), (float)Minecraft.getInstance().getFrameTimeNs());
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.fillRect(x, y + Mth.floor((float)(16.0f * (1.0f - f))), 16, Mth.ceil((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    public boolean shouldRenderFluid(ItemStack pStack, int pX, int pY, boolean includeCarried, boolean reverseBounds) {
        if (!(this.screen instanceof CardFluidScreen)) {
            return reverseBounds;
        }
        CardFluidScreen cardFluidScreen = (CardFluidScreen)this.screen;
        if (((CardItemContainer)cardFluidScreen.getMenu()).getCarried().equals(pStack) && includeCarried) {
            return reverseBounds;
        }
        if (reverseBounds) {
            return !MiscTools.inBounds(cardFluidScreen.filterStartX, cardFluidScreen.filterStartY, cardFluidScreen.filterEndX - cardFluidScreen.filterStartX, cardFluidScreen.filterEndY - cardFluidScreen.filterStartY, pX, pY);
        }
        if (!MiscTools.inBounds(cardFluidScreen.filterStartX, cardFluidScreen.filterStartY, cardFluidScreen.filterEndX - cardFluidScreen.filterStartX, cardFluidScreen.filterEndY - cardFluidScreen.filterStartY, pX, pY)) {
            return reverseBounds;
        }
        Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)pStack);
        if (!fluidHandlerLazyOptional.isPresent()) {
            return reverseBounds;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        if (fluidStack.isEmpty()) {
            return reverseBounds;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return reverseBounds;
        }
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return reverseBounds;
        }
        return !reverseBounds;
    }

    public void renderFluid(FluidStack fluidStack, int pX, int pY, int size) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        PoseStack posestack = this.pose();
        posestack.pushPose();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        int zLevel = 100;
        float uMin = fluidStillSprite.getU0();
        float uMax = fluidStillSprite.getU1();
        float vMin = fluidStillSprite.getV0();
        float vMax = fluidStillSprite.getV1();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.addVertex((float)pX, (float)(pY + size), (float)zLevel).setUv(uMin, vMax);
        vertexBuffer.addVertex((float)(pX + size), (float)(pY + size), (float)zLevel).setUv(uMax, vMax);
        vertexBuffer.addVertex((float)(pX + size), (float)pY, (float)zLevel).setUv(uMax, vMin);
        vertexBuffer.addVertex((float)pX, (float)pY, (float)zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        posestack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderItem(ItemStack pStack, int pX, int pY, int something) {
        if (!this.shouldRenderFluid(pStack, pX, pY, true, false)) {
            super.renderItem(pStack, pX, pY, something);
            return;
        }
        Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)pStack);
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        PoseStack posestack = this.pose();
        posestack.pushPose();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        int zLevel = 100;
        float uMin = fluidStillSprite.getU0();
        float uMax = fluidStillSprite.getU1();
        float vMin = fluidStillSprite.getV0();
        float vMax = fluidStillSprite.getV1();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.addVertex(posestack.last().pose(), (float)pX, (float)pY + 16.0f, (float)zLevel).setUv(uMin, vMax);
        vertexBuffer.addVertex(posestack.last().pose(), (float)pX + 16.0f, (float)pY + 16.0f, (float)zLevel).setUv(uMax, vMax);
        vertexBuffer.addVertex(posestack.last().pose(), (float)pX + 16.0f, (float)pY, (float)zLevel).setUv(uMax, vMin);
        vertexBuffer.addVertex(posestack.last().pose(), (float)pX, (float)pY, (float)zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        posestack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }
}

