/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.forger;

import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlock;
import plus.dragons.createenchantmentindustry.common.processing.forger.BlazeForgerBlockEntity;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;

public class BlazeForgerArmInteractionPoint
extends ArmInteractionPoint {
    public BlazeForgerArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof BlazeForgerBlockEntity)) {
            return stack;
        }
        BlazeForgerBlockEntity forger = (BlazeForgerBlockEntity)blockEntity;
        ItemStack input = stack.copy();
        InteractionResultHolder<ItemStack> result = BlazeExperienceBlock.applyFuel(this.cachedState, this.level, this.pos, input, false, false, simulate);
        if (result.getResult().consumesAction()) {
            ItemStack remainder = (ItemStack)result.getObject();
            if (input.isEmpty()) {
                return remainder;
            }
            if (!simulate) {
                Containers.dropItemStack((Level)this.level, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), (ItemStack)remainder);
            }
            return input;
        }
        if (result.getResult() == InteractionResult.PASS) {
            return forger.insertItem(input, simulate);
        }
        return input;
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof BlazeForgerBlockEntity) {
            BlazeForgerBlockEntity forger = (BlazeForgerBlockEntity)blockEntity;
            return forger.inventory.extractItem(slot += 2, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotCount(ArmBlockEntity armBlockEntity) {
        return 2;
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return CEIBlocks.BLAZE_FORGER.has(state);
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BlazeForgerArmInteractionPoint(this, level, pos, state);
        }
    }
}

