/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabBreedTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabDanceTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabGoToHomePositionTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLayEggTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLocateBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabTravelToBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabWaveTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public final class CrabBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super CrabEntity>>> SENSORS;
    private static final UniformInt WAVE_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        CrabBrain.addCoreActivities((Brain<CrabEntity>)brain);
        CrabBrain.addIdleActivities((Brain<CrabEntity>)brain);
        CrabBrain.addLayEggActivities((Brain<CrabEntity>)brain);
        CrabBrain.addDanceActivities((Brain<CrabEntity>)brain);
        CrabBrain.addWaveActivities((Brain<CrabEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<CrabEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get())));
    }

    private static void addLayEggActivities(Brain<CrabEntity> brain) {
        brain.addActivityWithConditions((Activity)FriendsAndFoesActivities.CRAB_LAY_EGG.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabGoToHomePositionTask())), (Object)Pair.of((Object)1, (Object)((Object)new CrabLocateBurrowSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new CrabTravelToBurrowSpotTask())), (Object)Pair.of((Object)3, (Object)((Object)new CrabLayEggTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get()), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addDanceActivities(Brain<CrabEntity> brain) {
        brain.addActivityWithConditions((Activity)FriendsAndFoesActivities.CRAB_DANCE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabDanceTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get()), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addWaveActivities(Brain<CrabEntity> brain) {
        brain.addActivityWithConditions((Activity)FriendsAndFoesActivities.CRAB_WAVE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabWaveTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()), (Object)MemoryStatus.VALUE_ABSENT)}));
    }

    private static void addIdleActivities(Brain<CrabEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(crab -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)((Object)new CrabBreedTask((EntityType<? extends Animal>)((EntityType)FriendsAndFoesEntityTypes.CRAB.get())))), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get()), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivities(CrabEntity crab) {
        crab.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)FriendsAndFoesActivities.CRAB_LAY_EGG.get()), (Object)((Activity)FriendsAndFoesActivities.CRAB_DANCE.get()), (Object)((Activity)FriendsAndFoesActivities.CRAB_WAVE.get()), (Object)Activity.IDLE));
    }

    public static void updateMemories(CrabEntity crab) {
        if (crab.hasEgg()) {
            crab.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)true);
        } else {
            crab.getBrain().eraseMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get());
        }
        if (crab.isDancing() && !crab.onClimbable()) {
            crab.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)true);
        } else {
            crab.getBrain().eraseMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get());
        }
    }

    public static void setWaveCooldown(CrabEntity crab) {
        crab.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)WAVE_COOLDOWN_PROVIDER.sample(crab.getRandom()));
    }

    public static Predicate<ItemStack> getTemptations() {
        return itemStack -> itemStack.is(FriendsAndFoesTags.CRAB_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ADULT, (SensorType)FriendsAndFoesSensorTypes.CRAB_TEMPTATIONS.get());
        MEMORY_MODULES = List.of(MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get());
        WAVE_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)20, (int)40);
    }
}

