/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.event;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailRegistry;
import it.hurts.shatterbyte.reanimal.client.renderer.butterfly.ButterflyRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.capybara.CapybaraRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.crocodile.CrocodileRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.dragonfly.DragonflyRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.giraffe.GiraffeRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.glow_stick.GlowStickRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.hedgehog.HedgehogRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.hippopotamus.HippopotamusRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.jellyfish.JellyfishRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.kiwi.KiwiRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.ostrich.OstrichRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.penguin.PenguinRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.pigeon.PigeonRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.sea_urchin.SeaUrchinRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.seal.SealRenderer;
import it.hurts.shatterbyte.reanimal.client.renderer.vulture.VultureRenderer;
import it.hurts.shatterbyte.reanimal.client.sound.ButterflySoundInstance;
import it.hurts.shatterbyte.reanimal.client.sound.DragonflySoundInstance;
import it.hurts.shatterbyte.reanimal.common.entity.butterfly.ButterflyEntity;
import it.hurts.shatterbyte.reanimal.common.entity.dragonfly.DragonflyEntity;
import it.hurts.shatterbyte.reanimal.common.entity.glow_stick.GlowStickEntity;
import it.hurts.shatterbyte.reanimal.common.entity.hedgehog.QuillArrowEntity;
import it.hurts.shatterbyte.reanimal.common.entity.vulture.VultureEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalBlocks;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import it.hurts.shatterbyte.reanimal.init.ReAnimalPotions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

@EventBusSubscriber(modid="reanimal")
public class ReAnimalModEvents {
    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        ReAnimalEntities.registerAttributes(event);
    }

    @SubscribeEvent
    public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ReAnimalEntities.HEDGEHOG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.OSTRICH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.KIWI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.PIGEON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.BUTTERFLY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ButterflyEntity::checkButterflySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.VULTURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VultureEntity::checkVultureSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.CAPYBARA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.SEAL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.HIPPOPOTAMUS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.CROCODILE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.GIRAFFE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.DRAGONFLY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.PENGUIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.SEA_URCHIN.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, (type, level, spawnType, pos, random) -> true, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ReAnimalEntities.JELLYFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, level, spawnType, pos, random) -> true, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void registerBrewing(RegisterBrewingRecipesEvent event) {
        Registry registry = event.getRegistryAccess().registryOrThrow(Registries.POTION);
        Holder.Reference quill = (Holder.Reference)registry.getHolder(ReAnimalPotions.QUILL.getKey()).orElseThrow();
        Holder.Reference longQuill = (Holder.Reference)registry.getHolder(ReAnimalPotions.LONG_QUILL.getKey()).orElseThrow();
        Holder.Reference strongQuill = (Holder.Reference)registry.getHolder(ReAnimalPotions.STRONG_QUILL.getKey()).orElseThrow();
        Holder.Reference cramps = (Holder.Reference)registry.getHolder(ReAnimalPotions.CRAMPS.getKey()).orElseThrow();
        Holder.Reference longCramps = (Holder.Reference)registry.getHolder(ReAnimalPotions.LONG_CRAMPS.getKey()).orElseThrow();
        Holder.Reference strongCramps = (Holder.Reference)registry.getHolder(ReAnimalPotions.STRONG_CRAMPS.getKey()).orElseThrow();
        event.getBuilder().addMix(Potions.AWKWARD, (Item)ReAnimalItems.QUILL.get(), (Holder)quill);
        event.getBuilder().addMix((Holder)quill, Items.REDSTONE, (Holder)longQuill);
        event.getBuilder().addMix((Holder)quill, Items.GLOWSTONE_DUST, (Holder)strongQuill);
        event.getBuilder().addMix(Potions.AWKWARD, (Item)ReAnimalItems.SEA_URCHIN_CAVIAR.get(), (Holder)cramps);
        event.getBuilder().addMix((Holder)cramps, Items.REDSTONE, (Holder)longCramps);
        event.getBuilder().addMix((Holder)cramps, Items.GLOWSTONE_DUST, (Holder)strongCramps);
    }

    @EventBusSubscriber(modid="reanimal", value={Dist.CLIENT})
    public static class ClientOnlyEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)ReAnimalBlocks.QUILL_PLATFORM.get()), (RenderType)RenderType.cutout()));
            EntityTrailRegistry.registerProvider((EntityType)((EntityType)ReAnimalEntities.GLOW_STICK.get()), GlowStickEntity.TrailProvider::new);
        }

        @SubscribeEvent
        public static void onEntityJoin(EntityJoinLevelEvent event) {
            if (!event.getLevel().isClientSide()) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity instanceof ButterflyEntity) {
                ButterflyEntity butterfly = (ButterflyEntity)entity;
                Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new ButterflySoundInstance(butterfly));
            }
            if ((entity = event.getEntity()) instanceof DragonflyEntity) {
                DragonflyEntity dragonfly = (DragonflyEntity)entity;
                Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new DragonflySoundInstance(dragonfly));
            }
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ReAnimalEntities.HEDGEHOG.get(), HedgehogRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.OSTRICH.get(), OstrichRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.KIWI.get(), KiwiRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.PIGEON.get(), PigeonRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.BUTTERFLY.get(), ButterflyRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.CAPYBARA.get(), CapybaraRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.SEAL.get(), SealRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.HIPPOPOTAMUS.get(), HippopotamusRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.CROCODILE.get(), CrocodileRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.GIRAFFE.get(), GiraffeRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.DRAGONFLY.get(), DragonflyRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.VULTURE.get(), VultureRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.PENGUIN.get(), PenguinRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.SEA_URCHIN.get(), SeaUrchinRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.JELLYFISH.get(), JellyfishRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.KIWI_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.OSTRICH_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.PIGEON_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.VULTURE_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.PENGUIN_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.CROCODILE_EGG.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.GLOW_STICK.get(), GlowStickRenderer::new);
            event.registerEntityRenderer((EntityType)ReAnimalEntities.QUILL_ARROW.get(), context -> new ArrowRenderer<QuillArrowEntity>(context){

                public ResourceLocation getTextureLocation(QuillArrowEntity entity) {
                    return ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/quill_arrow.png");
                }
            });
        }
    }
}

