/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.item;

import it.hurts.shatterbyte.reanimal.common.entity.glow_stick.GlowStickEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GlowStickItem
extends Item {
    public GlowStickItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        GlowStickEntity projectile;
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.PLAYERS, 0.5f, 0.9f + level.random.nextFloat() * 0.2f);
        if (!level.isClientSide() && (projectile = (GlowStickEntity)((EntityType)ReAnimalEntities.GLOW_STICK.get()).create(level)) instanceof GlowStickEntity) {
            GlowStickEntity glowStick = projectile;
            glowStick.setItem(stack.copyWithCount(1));
            glowStick.setOwner((Entity)player);
            glowStick.setPos(player.getEyePosition());
            glowStick.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 0.8f);
            level.addFreshEntity((Entity)glowStick);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        boolean isHeld;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = isHeld = player.getMainHandItem() == stack || player.getOffhandItem() == stack;
        if (!isHeld) {
            return;
        }
        GlowStickEntity.tryPlaceGlowLight(level, BlockPos.containing((Position)player.position()));
    }
}

