/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.sea_urchin;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.sea_urchin.SeaUrchinAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalDamageTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalMobEffects;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SeaUrchinEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sea_urchin.idle");
    private static final RawAnimation WOBBLE = RawAnimation.begin().thenLoop("animation.sea_urchin.wobbling");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SeaUrchinEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("seaUrchinBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("seaUrchinActivityUpdate");
        SeaUrchinAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        if (!this.isBaby()) {
            List targets = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), candidate -> !(candidate instanceof SeaUrchinEntity));
            for (LivingEntity target : targets) {
                if (!target.hurt(this.damageSources().source(ReAnimalDamageTypes.SEA_URCHIN_SPIKES, (Entity)this), 5.0f)) continue;
                target.addEffect(new MobEffectInstance(ReAnimalMobEffects.CRAMPS, 200, 0));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity entity;
        Entity attacker;
        boolean result = super.hurt(source, amount);
        if (result && !this.level().isClientSide() && (attacker = source.getEntity()) instanceof LivingEntity && (entity = (LivingEntity)attacker).getMainHandItem().isEmpty() && entity.hurt(this.damageSources().source(ReAnimalDamageTypes.SEA_URCHIN_SPIKES, (Entity)this), 3.0f)) {
            entity.addEffect(new MobEffectInstance(ReAnimalMobEffects.CRAMPS, 100, 0));
        }
        return result;
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater() && this.onGround()) {
            float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 25.0f;
            this.moveRelative(speed * 0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            super.travel(vec);
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this, (Mob)this){

            public void clientTick() {
            }
        };
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType type) {
        return true;
    }

    protected Brain.Provider<SeaUrchinEntity> brainProvider() {
        return SeaUrchinAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SeaUrchinAI.makeBrain((Brain<SeaUrchinEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.SEA_URCHIN_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.SEA_URCHIN_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.SEA_URCHIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.SEA_URCHIN_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        SeaUrchinEntity baby = (SeaUrchinEntity)((EntityType)ReAnimalEntities.SEA_URCHIN.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<SeaUrchinEntity> state) {
        AnimationController controller = state.getController();
        SeaUrchinEntity entity = (SeaUrchinEntity)state.getAnimatable();
        if (!entity.onGround() || entity.getDeltaMovement().multiply(1.0, 0.0, 1.0).length() > 0.0) {
            controller.setAnimation(WOBBLE);
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.025).add(NeoForgeMod.SWIM_SPEED, 0.1).add(Attributes.FOLLOW_RANGE, 4.0);
    }
}

