/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.jellyfish;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.jellyfish.JellyfishAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalDamageTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalMobEffects;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JellyfishEntity
extends WaterAnimal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.jellyfish.idle");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.jellyfish.swim");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float xBodyRot;
    public float xBodyRotO;
    public float tentacleMovement;
    private float speed;
    private float tentacleSpeed;
    private float tx;
    private float ty;
    private float tz;

    public JellyfishEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.random.setSeed((long)this.getId());
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.15f;
    }

    public int getVariant() {
        return (Integer)this.getEntityData().get(VARIANT);
    }

    public void setVariant(int variant) {
        this.getEntityData().set(VARIANT, (Object)variant);
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(VARIANT, (Object)this.getRandom().nextInt(5));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getInt("variant"));
    }

    protected Brain.Provider<JellyfishEntity> brainProvider() {
        return JellyfishAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return JellyfishAI.makeBrain((Brain<JellyfishEntity>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("jellyfishBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("jellyfishActivityUpdate");
        JellyfishAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        if (!this.isBaby()) {
            List targets = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), candidate -> !(candidate instanceof JellyfishEntity));
            for (LivingEntity target : targets) {
                if (!target.hurt(this.damageSources().source(ReAnimalDamageTypes.JELLYFISH_STING, (Entity)this), 3.0f)) continue;
                target.addEffect(new MobEffectInstance(ReAnimalMobEffects.CRAMPS, 200, 0));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity entity;
        Entity attacker;
        boolean result = super.hurt(source, amount);
        if (result && !this.level().isClientSide() && (attacker = source.getEntity()) instanceof LivingEntity && (entity = (LivingEntity)attacker).getMainHandItem().isEmpty() && entity.hurt(this.damageSources().source(ReAnimalDamageTypes.JELLYFISH_STING, (Entity)this), 1.0f)) {
            entity.addEffect(new MobEffectInstance(ReAnimalMobEffects.CRAMPS, 100, 0));
        }
        return result;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.JELLYFISH_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.JELLYFISH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.JELLYFISH_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.level().isClientSide()) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.15f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.isInWaterOrBubble()) {
            float progress;
            this.speed = this.tentacleMovement < (float)Math.PI ? ((double)(progress = this.tentacleMovement / (float)Math.PI) > 0.85 ? 0.11f : 0.06f) : (this.speed *= 0.85f);
            if (this.speed < 0.02f) {
                this.speed = 0.02f;
            }
            Vec3 desired = new Vec3((double)this.tx, (double)this.ty, (double)this.tz);
            double desiredSqr = desired.lengthSqr();
            Vec3 motion = this.getDeltaMovement();
            double motionSqr = motion.lengthSqr();
            Vec3 facing = null;
            if (desiredSqr > 1.0E-4 && !this.level().isClientSide()) {
                facing = desired.normalize();
            } else if (motionSqr > 1.0E-4) {
                facing = motion.normalize();
            }
            if (facing != null) {
                boolean verticalBlocked;
                float targetYaw = -((float)Mth.atan2((double)facing.x, (double)facing.z)) * 57.295776f;
                float targetPitch = -((float)Mth.atan2((double)facing.y, (double)Math.sqrt(facing.x * facing.x + facing.z * facing.z))) * 57.295776f;
                targetPitch = Mth.clamp((float)targetPitch, (float)-60.0f, (float)60.0f);
                BlockPos abovePos = this.blockPosition().above(3);
                BlockPos belowPos = this.blockPosition().below(3);
                FluidState aboveFluid = this.level().getFluidState(abovePos);
                FluidState belowFluid = this.level().getFluidState(belowPos);
                boolean surfaceBlocked = !aboveFluid.is(FluidTags.WATER);
                boolean groundBlocked = !belowFluid.is(FluidTags.WATER);
                boolean bl = verticalBlocked = surfaceBlocked && groundBlocked;
                if (verticalBlocked) {
                    targetPitch = Mth.lerp((float)0.35f, (float)targetPitch, (float)0.0f);
                } else if (surfaceBlocked && targetPitch < 0.0f) {
                    targetPitch = Mth.clamp((float)Mth.lerp((float)0.6f, (float)targetPitch, (float)40.0f), (float)15.0f, (float)70.0f);
                } else if (groundBlocked && targetPitch > 0.0f) {
                    targetPitch = Mth.clamp((float)Mth.lerp((float)0.35f, (float)targetPitch, (float)-30.0f), (float)-60.0f, (float)-10.0f);
                }
                this.yBodyRot = this.yHeadRot = Mth.rotLerp((float)0.015f, (float)this.yHeadRot, (float)targetYaw);
                this.setYRot(this.yBodyRot);
                this.xBodyRot = Mth.rotLerp((float)0.03f, (float)this.xBodyRot, (float)targetPitch);
                this.setXRot(this.xBodyRot);
                if (!this.level().isClientSide()) {
                    Vec3 moveFacing = Vec3.directionFromRotation((float)this.getXRot(), (float)this.getYRot());
                    Vec3 target = moveFacing.scale((double)this.speed);
                    if (verticalBlocked) {
                        target = new Vec3(target.x, 0.0, target.z);
                    } else {
                        if (surfaceBlocked) {
                            target = new Vec3(target.x, Math.min(target.y, -0.02), target.z);
                        }
                        if (groundBlocked && target.y < 0.0) {
                            target = new Vec3(target.x, 0.0, target.z);
                        }
                    }
                    if (target.lengthSqr() > 1.0E-6) {
                        AABB nextBox = this.getBoundingBox().move(target);
                        if (!this.level().noCollision((Entity)this, nextBox) || this.horizontalCollision || this.isWallAhead(moveFacing)) {
                            target = this.findWaterAvoidance(target);
                        }
                    }
                    if (target.lengthSqr() > 1.0E-6) {
                        Vec3 forwardPos = this.position().add(target.normalize());
                        BlockPos forwardBlock = BlockPos.containing((Position)forwardPos);
                        FluidState forwardFluid = this.level().getFluidState(forwardBlock);
                        if (!forwardFluid.is(FluidTags.WATER)) {
                            target = new Vec3(target.x * -0.5, Math.max(0.05, target.y), target.z * -0.5);
                        }
                    }
                    Vec3 current = this.getDeltaMovement();
                    this.setDeltaMovement(current.add(target.subtract(current).scale(0.1)));
                }
            } else {
                this.xBodyRot = Mth.rotLerp((float)0.01f, (float)this.xBodyRot, (float)0.0f);
                this.setXRot(this.xBodyRot);
            }
        } else {
            if (!this.level().isClientSide()) {
                double vertical = this.getDeltaMovement().y;
                vertical = this.hasEffect(MobEffects.LEVITATION) ? 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) : (vertical -= this.getGravity());
                this.setDeltaMovement(0.0, vertical * (double)0.98f, 0.0);
            }
            this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
        }
    }

    public void travel(Vec3 travelVector) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void handleEntityEvent(byte id) {
        if (id == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void setMovementVector(float tx, float ty, float tz) {
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    private Vec3 findWaterAvoidance(Vec3 currentTarget) {
        Vec3[] options;
        Vec3 horizontal = new Vec3(currentTarget.x, 0.0, currentTarget.z);
        if (horizontal.lengthSqr() < 1.0E-6) {
            return currentTarget.scale(-0.5);
        }
        Vec3 dir = horizontal.normalize();
        for (Vec3 option : options = new Vec3[]{new Vec3(-dir.z, 0.0, dir.x), new Vec3(dir.z, 0.0, -dir.x), dir.scale(-1.0)}) {
            Vec3 candidate = new Vec3(option.x * (double)this.speed, currentTarget.y, option.z * (double)this.speed);
            if (!this.isWaterPath(candidate)) continue;
            return candidate;
        }
        return currentTarget.scale(-0.5);
    }

    private boolean isWallAhead(Vec3 direction) {
        if (direction.lengthSqr() < 1.0E-6) {
            return false;
        }
        BlockPos forwardPos = BlockPos.containing((Position)this.position().add(direction.normalize().scale(3.0)));
        BlockState state = this.level().getBlockState(forwardPos);
        if (!state.getCollisionShape((BlockGetter)this.level(), forwardPos).isEmpty()) {
            return true;
        }
        FluidState fluid = this.level().getFluidState(forwardPos);
        return !fluid.is(FluidTags.WATER);
    }

    private boolean isWaterPath(Vec3 candidate) {
        if (candidate.lengthSqr() < 1.0E-6) {
            return false;
        }
        AABB nextBox = this.getBoundingBox().move(candidate);
        if (!this.level().noCollision((Entity)this, nextBox)) {
            return false;
        }
        BlockPos aheadPos = BlockPos.containing((Position)this.position().add(candidate.normalize()));
        FluidState aheadFluid = this.level().getFluidState(aheadPos);
        return aheadFluid.is(FluidTags.WATER);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<JellyfishEntity> state) {
        AnimationController controller = state.getController();
        JellyfishEntity entity = (JellyfishEntity)state.getAnimatable();
        if (entity.isInWaterOrBubble() && entity.tentacleMovement < (float)Math.PI) {
            controller.setAnimation(SWIM);
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(NeoForgeMod.SWIM_SPEED, 0.6).add(Attributes.FOLLOW_RANGE, 12.0);
    }
}

