/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.jellyfish;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.jellyfish.JellyfishEntity;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class JellyfishAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super JellyfishEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.DANGER_DETECTED_RECENTLY);

    public static Brain.Provider<JellyfishEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<JellyfishEntity> brain) {
        JellyfishAI.initCoreActivity(brain);
        JellyfishAI.initIdleActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<JellyfishEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<JellyfishEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new JellyfishFlee())), (Object)Pair.of((Object)2, (Object)((Object)new JellyfishWander())), (Object)Pair.of((Object)3, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)120, (int)200), 30.0f, 0.0f, 0.0f))));
    }

    public static void updateActivity(JellyfishEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
    }

    private static class JellyfishFlee
    extends Behavior<JellyfishEntity> {
        public JellyfishFlee() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT));
        }

        protected boolean canStillUse(ServerLevel level, JellyfishEntity jellyfish, long gameTime) {
            return jellyfish.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY);
        }

        protected void tick(ServerLevel level, JellyfishEntity jellyfish, long gameTime) {
            LivingEntity attacker = jellyfish.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).orElse(null);
            if (attacker == null) {
                return;
            }
            Vec3 away = new Vec3(jellyfish.getX() - attacker.getX(), jellyfish.getY() - attacker.getY(), jellyfish.getZ() - attacker.getZ());
            BlockState state = level.getBlockState(BlockPos.containing((double)(jellyfish.getX() + away.x), (double)(jellyfish.getY() + away.y), (double)(jellyfish.getZ() + away.z)));
            FluidState fluidState = level.getFluidState(BlockPos.containing((double)(jellyfish.getX() + away.x), (double)(jellyfish.getY() + away.y), (double)(jellyfish.getZ() + away.z)));
            if (fluidState.is(FluidTags.WATER) || state.isAir()) {
                double distance = away.length();
                if (distance > 0.0) {
                    away = away.normalize();
                    double strength = 2.0;
                    if (distance > 5.0) {
                        strength -= (distance - 5.0) / 5.0;
                    }
                    if (strength > 0.0) {
                        away = away.scale(strength);
                    }
                }
                if (state.isAir()) {
                    away = away.subtract(0.0, away.y, 0.0);
                }
                jellyfish.setMovementVector((float)away.x / 25.0f, (float)away.y / 25.0f, (float)away.z / 25.0f);
            }
        }
    }

    private static class JellyfishWander
    extends Behavior<JellyfishEntity> {
        public JellyfishWander() {
            super((Map)ImmutableMap.of());
        }

        protected boolean checkExtraStartConditions(ServerLevel level, JellyfishEntity entity) {
            return true;
        }

        protected boolean canStillUse(ServerLevel level, JellyfishEntity entity, long gameTime) {
            return true;
        }

        protected void tick(ServerLevel level, JellyfishEntity jellyfish, long gameTime) {
            int idleTicks = jellyfish.getNoActionTime();
            if (idleTicks > 160) {
                jellyfish.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (jellyfish.getRandom().nextInt(80) == 0 || !jellyfish.isInWaterOrBubble() || !jellyfish.hasMovementVector()) {
                float angle = jellyfish.getRandom().nextFloat() * ((float)Math.PI * 2);
                float x = Mth.cos((float)angle) * 0.08f;
                float y = -0.14f + jellyfish.getRandom().nextFloat() * 0.28f;
                float z = Mth.sin((float)angle) * 0.08f;
                jellyfish.setMovementVector(x, y, z);
            }
        }
    }
}

