/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.hedgehog;

import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class QuillArrowEntity
extends AbstractArrow {
    public QuillArrowEntity(EntityType<QuillArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public QuillArrowEntity(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super((EntityType)ReAnimalEntities.QUILL_ARROW.get(), x, y, z, level, pickup, weapon);
    }

    public QuillArrowEntity(Level level, LivingEntity owner, ItemStack pickup, ItemStack weapon) {
        super((EntityType)ReAnimalEntities.QUILL_ARROW.get(), owner, level, pickup, weapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ReAnimalItems.QUILL_ARROW.get());
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    public void tick() {
        if (!this.inGround && !this.isNoGravity()) {
            Vec3 motion = this.getDeltaMovement().scale(0.92).add(0.0, -0.03, 0.0);
            this.setDeltaMovement(motion);
        }
        super.tick();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, this.getDefaultPickupItem());
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }
}

