/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.dragonfly;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.dragonfly.DragonflyAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonflyEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.dragonfly.idle");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.dragonfly.fly");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public int getVariant() {
        return (Integer)this.getEntityData().get(VARIANT);
    }

    public void setVariant(int variant) {
        this.getEntityData().set(VARIANT, (Object)variant);
    }

    public DragonflyEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.navigation = new FlyingPathNavigation((Mob)this, this.level());
        this.getNavigation().setCanFloat(true);
        this.setNoGravity(true);
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            super.customServerAiStep();
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.tickScared(serverLevel);
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("dragonflyBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("dragonflyActivityUpdate");
        DragonflyAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(VARIANT, (Object)this.getRandom().nextInt(5));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getInt("variant"));
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.resetFallDistance();
    }

    protected Brain.Provider<DragonflyEntity> brainProvider() {
        return DragonflyAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return DragonflyAI.makeBrain((Brain<DragonflyEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.DRAGONFLY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.DRAGONFLY_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private void tickScared(ServerLevel level) {
        LivingEntity scary = null;
        for (LivingEntity entity2 : level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(5.0, 2.0, 5.0), entity -> entity != this)) {
            if (!this.isScaredBy(entity2)) continue;
            scary = entity2;
            break;
        }
        if (scary == null) {
            return;
        }
        if (this.getNavigation().isDone()) {
            Vec3 away;
            Vec3 dir = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
            if (dir.dot(away = this.position().subtract(scary.position()).multiply(1.0, 0.0, 1.0).normalize()) < 0.0) {
                dir = dir.scale(-1.0);
            }
            dir = away.scale(0.5).add(dir.scale(0.5)).normalize();
            Vec3 center = this.position().add(dir.scale(16.0));
            BlockPos ground = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.containing((Position)center));
            Vec3 target = ground.getCenter();
            this.getNavigation().moveTo(target.x, target.y, target.z, 1.0);
        }
    }

    public boolean isScaredBy(LivingEntity entity) {
        if (!this.getBoundingBox().inflate(5.0, 2.0, 5.0).intersects(entity.getBoundingBox())) {
            return false;
        }
        if (entity instanceof Frog) {
            return true;
        }
        if (this.getLastHurtByMob() == entity) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isSpectator() && (player.isSprinting() || player.isPassenger());
        }
        return false;
    }

    private PlayState mainPredicate(AnimationState<DragonflyEntity> state) {
        AnimationController controller = state.getController();
        DragonflyEntity entity = (DragonflyEntity)state.getAnimatable();
        if (state.isMoving() || !entity.onGround()) {
            controller.setAnimation(FLY);
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 8.0);
    }
}

