/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.crocodile;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.block.CrocodileEggBlock;
import it.hurts.shatterbyte.reanimal.common.entity.crocodile.CrocodileAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalBlocks;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrocodileEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.crocodile.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.crocodile.walk");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.crocodile.swim");
    private static final RawAnimation ATTACK_1 = RawAnimation.begin().then("animation.crocodile.bite", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation ATTACK_2 = RawAnimation.begin().then("animation.crocodile.spinn", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation[] ATTACKS = new RawAnimation[]{ATTACK_1, ATTACK_2};
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackAnimationTicks;
    @Nullable
    private BlockPos environmentTarget;

    public CrocodileEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 1.0f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = new AmphibiousPathNavigation((Mob)this, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public void startAttackAnimation() {
        this.attackAnimationTicks = 12;
        this.setAttacking(true);
    }

    public void setEnvironmentTarget(@Nullable BlockPos pos) {
        this.environmentTarget = pos;
    }

    @Nullable
    public BlockPos getEnvironmentTarget() {
        return this.environmentTarget;
    }

    public boolean hasEnvironmentTarget() {
        return this.environmentTarget != null;
    }

    public void clearEnvironmentTarget() {
        this.environmentTarget = null;
    }

    public boolean isAtEnvironmentTarget() {
        if (this.environmentTarget == null) {
            return false;
        }
        return this.blockPosition().closerThan((Vec3i)this.environmentTarget, 2.0);
    }

    protected void customServerAiStep() {
        Brain brain = this.getBrain();
        LivingEntity lastAttacker = this.getLastHurtByMob();
        if (lastAttacker != null && CrocodileAI.isValidTarget(this, lastAttacker)) {
            brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)lastAttacker);
        }
        brain.getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> {
            if (!CrocodileAI.isValidTarget(this, target) || CrocodileAI.isHoldingFavoriteFood(target)) {
                brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
                brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            }
        });
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("crocodileBrain");
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("crocodileActivityUpdate");
        CrocodileAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.attackAnimationTicks > 0) {
            --this.attackAnimationTicks;
            if (this.attackAnimationTicks == 0 && this.isAttacking()) {
                this.setAttacking(false);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.tickEggLaying();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("hasEgg", this.hasEgg());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setHasEgg(tag.getBoolean("hasEgg"));
    }

    protected Brain.Provider<CrocodileEntity> brainProvider() {
        return CrocodileAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CrocodileAI.makeBrain((Brain<CrocodileEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.CROCODILE_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.CROCODILE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.CROCODILE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.CROCODILE_DEATH.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return (AgeableMob)((EntityType)ReAnimalEntities.CROCODILE.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(ServerLevel level, Animal mate) {
        if (!(mate instanceof CrocodileEntity)) {
            super.spawnChildFromBreeding(level, mate);
            return;
        }
        CrocodileEntity crocodileMate = (CrocodileEntity)mate;
        if (this.hasEgg() || crocodileMate.hasEgg()) {
            return;
        }
        this.setHasEgg(true);
        this.finalizeSpawnChildFromBreeding(level, mate, null);
    }

    public boolean canMate(Animal other) {
        CrocodileEntity crocodile;
        if (this.hasEgg()) {
            return false;
        }
        if (other instanceof CrocodileEntity && (crocodile = (CrocodileEntity)other).hasEgg()) {
            return false;
        }
        return super.canMate(other);
    }

    public void updateSwimming() {
        this.setSwimming(this.isEffectiveAi() && this.isInWaterOrBubble());
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWaterOrBubble() && this.isSwimming()) {
            float swimSpeed = (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED);
            this.moveRelative(swimSpeed, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().x, 0.3, this.getDeltaMovement().z);
            }
        } else {
            super.travel(travelVector);
        }
    }

    public boolean doHurtTarget(Entity target) {
        return super.doHurtTarget(target);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 5, this::attackPredicate));
    }

    private PlayState mainPredicate(AnimationState<CrocodileEntity> state) {
        AnimationController controller = state.getController();
        if (state.isMoving()) {
            if (this.isInWater()) {
                controller.setAnimation(SWIM);
            } else {
                controller.setAnimation(WALK);
            }
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<CrocodileEntity> state) {
        AnimationController controller = state.getController();
        if (this.isAttacking()) {
            this.setAttacking(false);
            controller.forceAnimationReset();
            controller.setAnimation((RawAnimation)Util.getRandom((Object[])ATTACKS, (RandomSource)this.getRandom()));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(NeoForgeMod.SWIM_SPEED, 0.05).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 1.1).add(Attributes.ATTACK_DAMAGE, 10.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(ATTACKING, (Object)false);
        buidler.define(HAS_EGG, (Object)false);
    }

    private void tickEggLaying() {
        BlockPos target;
        BlockPos pos;
        if (this.isBaby()) {
            return;
        }
        if (!this.hasEgg()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level();
        if (this.canLayEggAt(level, pos = this.blockPosition())) {
            this.layEgg(level, pos);
            this.setHasEgg(false);
        } else if (this.tickCount % 200 == 0 && !this.hasEnvironmentTarget() && (target = this.findEggLayTarget(level)) != null) {
            this.setEnvironmentTarget(target);
        }
    }

    private boolean canLayEggAt(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() && level.getFluidState(pos).isEmpty();
    }

    private void layEgg(ServerLevel level, BlockPos pos) {
        int eggs = Mth.nextInt((RandomSource)this.random, (int)1, (int)4);
        BlockState state = (BlockState)((CrocodileEggBlock)((Object)ReAnimalBlocks.CROCODILE_EGG.get())).defaultBlockState().setValue((Property)CrocodileEggBlock.EGGS, (Comparable)Integer.valueOf(eggs));
        level.setBlock(pos, state, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)this, (BlockState)state));
        this.playSound(SoundEvents.TURTLE_LAY_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Nullable
    private BlockPos findEggLayTarget(ServerLevel level) {
        BlockPos origin = this.blockPosition();
        RandomSource random = this.getRandom();
        for (int i = 0; i < 40; ++i) {
            BlockPos eggPos;
            BlockPos ground;
            int z;
            int dx = random.nextInt(17) - 8;
            int dz = random.nextInt(17) - 8;
            int x = origin.getX() + dx;
            int topY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = origin.getZ() + dz);
            if (topY <= level.getMinBuildHeight() || !level.getBlockState(ground = (eggPos = new BlockPos(x, topY, z)).below()).is(BlockTags.SAND) || !level.getBlockState(eggPos).isAir() || !level.getFluidState(eggPos).isEmpty()) continue;
            return eggPos;
        }
        return null;
    }
}

