/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.crocodile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.crocodile.CrocodileEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CrocodileAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super CrocodileEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.CROCODILE_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT, (Object)SensorType.NEAREST_PLAYERS);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_PLAYER});
    public static final int ATTACK_ANIMATION_TICKS = 12;
    private static final int ATTACK_HIT_TICK = 11;
    private static final int ATTACK_COOLDOWN_TICKS = 20;

    public static Brain.Provider<CrocodileEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<CrocodileEntity> brain) {
        CrocodileAI.initCoreActivity(brain);
        CrocodileAI.initIdleActivity(brain);
        CrocodileAI.initPanicActivity(brain);
        CrocodileAI.initFightActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<CrocodileEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<CrocodileEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create(CrocodileAI::findNearestAttackableEntity)), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.CROCODILE.get(), 1.0f, 1)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)3, (int)6), (float)1.25f), (Object)1)))), (Object)Pair.of((Object)4, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)5, (Object)((Object)new CrocodileMoveToEnvironmentTarget(1.2f))), (Object)Pair.of((Object)7, (Object)new RunOne((Map)ImmutableMap.of(), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new CrocodileSwim(1.2f)), (Object)1), (Object)Pair.of((Object)((Object)new CrocodileLandStroll(1.0f, 50, 100, 100, 200)), (Object)1))))));
    }

    private static void initFightActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)((Object)new CrocodileAttack(12, 11, 20)), (Object)StopAttackingIfTargetInvalid.create()), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initPanicActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.PANIC, 10, ImmutableList.of((Object)new AnimalPanic(2.5f, mob -> DamageTypeTags.PANIC_CAUSES)), MemoryModuleType.IS_PANICKING);
    }

    public static void updateActivity(CrocodileEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.CROCODILE_FOOD);
    }

    private static Optional<LivingEntity> getAttackTarget(CrocodileEntity entity) {
        return entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
    }

    private static Optional<? extends LivingEntity> findNearestAttackableEntity(CrocodileEntity entity) {
        Brain brain = entity.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || !brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)) {
            return Optional.empty();
        }
        double followRange = entity.getAttributeValue(Attributes.FOLLOW_RANGE);
        double maxDistanceSq = followRange * followRange;
        Optional<Player> playerTarget = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(target -> CrocodileAI.isValidTarget(entity, (LivingEntity)target) && target.distanceToSqr((Entity)entity) <= maxDistanceSq);
        if (playerTarget.isPresent()) {
            return playerTarget;
        }
        return brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty()).findClosest(target -> CrocodileAI.isValidTarget(entity, target) && target.distanceToSqr((Entity)entity) <= maxDistanceSq);
    }

    public static boolean isValidTarget(CrocodileEntity self, LivingEntity target) {
        return target.getType() != ReAnimalEntities.CROCODILE.get() && !(target instanceof Monster) && Sensor.isEntityAttackable((LivingEntity)self, (LivingEntity)target) && !CrocodileAI.isHoldingFavoriteFood(target);
    }

    public static boolean isHoldingFavoriteFood(LivingEntity target) {
        return target.getMainHandItem().is(ReAnimalTags.Items.CROCODILE_FOOD) || target.getOffhandItem().is(ReAnimalTags.Items.CROCODILE_FOOD);
    }

    public static class CrocodileMoveToEnvironmentTarget
    extends Behavior<CrocodileEntity> {
        private final float speed;

        public CrocodileMoveToEnvironmentTarget(float speed) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
            this.speed = speed;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, CrocodileEntity crocodile) {
            return crocodile.hasEnvironmentTarget() && !crocodile.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
        }

        protected void start(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            BlockPos target = crocodile.getEnvironmentTarget();
            if (target == null) {
                return;
            }
            crocodile.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, this.speed, 0));
        }

        protected boolean canStillUse(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            if (!crocodile.hasEnvironmentTarget()) {
                return false;
            }
            if (crocodile.isAtEnvironmentTarget()) {
                return false;
            }
            return !crocodile.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
        }

        protected void tick(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            BlockPos target = crocodile.getEnvironmentTarget();
            if (target == null) {
                return;
            }
            crocodile.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, this.speed, 0));
            if (crocodile.isAtEnvironmentTarget()) {
                crocodile.clearEnvironmentTarget();
            }
        }

        protected void stop(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            if (crocodile.isAtEnvironmentTarget()) {
                crocodile.clearEnvironmentTarget();
            }
            crocodile.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        }
    }

    public static class CrocodileSwim
    extends Behavior<CrocodileEntity> {
        private final float speed;

        public CrocodileSwim(float speed) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
            this.speed = speed;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, CrocodileEntity crocodile) {
            if (crocodile.hasEnvironmentTarget()) {
                return false;
            }
            return crocodile.isInWaterOrBubble();
        }

        protected void start(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            RandomSource random = crocodile.getRandom();
            for (int i = 0; i < 10; ++i) {
                double dz;
                double dy;
                double dx = crocodile.getX() + (random.nextDouble() * 2.0 - 1.0) * 6.0;
                BlockPos pos = BlockPos.containing((double)dx, (double)(dy = crocodile.getY() + (random.nextDouble() * 2.0 - 1.0)), (double)(dz = crocodile.getZ() + (random.nextDouble() * 2.0 - 1.0) * 6.0));
                if (!level.getFluidState(pos).is(FluidTags.WATER)) continue;
                crocodile.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, this.speed, 0));
                return;
            }
        }

        protected boolean canStillUse(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            if (crocodile.hasEnvironmentTarget()) {
                return false;
            }
            return crocodile.isInWaterOrBubble();
        }
    }

    public static class CrocodileLandStroll
    extends Behavior<CrocodileEntity> {
        private final float speed;
        private final int minRunTime;
        private final int maxRunTime;
        private final int minIdleTime;
        private final int maxIdleTime;
        private long endTick;
        private long nextStartTick;

        public CrocodileLandStroll(float speed, int minRunTime, int maxRunTime, int minIdleTime, int maxIdleTime) {
            super((Map)ImmutableMap.of());
            this.speed = speed;
            this.minRunTime = minRunTime;
            this.maxRunTime = maxRunTime;
            this.minIdleTime = minIdleTime;
            this.maxIdleTime = maxIdleTime;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, CrocodileEntity crocodile) {
            if (crocodile.hasEnvironmentTarget()) {
                return false;
            }
            if (crocodile.isSwimming()) {
                return false;
            }
            long gameTime = level.getGameTime();
            if (gameTime < this.nextStartTick) {
                return false;
            }
            Vec3 pos = LandRandomPos.getPos((PathfinderMob)crocodile, (int)10, (int)7);
            if (pos == null) {
                return false;
            }
            crocodile.getNavigation().moveTo(pos.x, pos.y, pos.z, (double)this.speed);
            this.endTick = gameTime + (long)Mth.nextInt((RandomSource)crocodile.getRandom(), (int)this.minRunTime, (int)this.maxRunTime);
            return true;
        }

        protected boolean canStillUse(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            if (crocodile.hasEnvironmentTarget()) {
                return false;
            }
            return !crocodile.isInWaterOrBubble() && !crocodile.getNavigation().isDone() && gameTime < this.endTick;
        }

        protected void start(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        }

        protected void stop(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
            crocodile.getNavigation().stop();
            this.nextStartTick = gameTime + (long)Mth.nextInt((RandomSource)crocodile.getRandom(), (int)this.minIdleTime, (int)this.maxIdleTime);
        }

        protected void tick(ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        }
    }

    private static class CrocodileAttack
    extends Behavior<CrocodileEntity> {
        private final int animationLength;
        private final int hitTick;
        private final int cooldownTicks;
        private int elapsedTicks;
        private boolean dealtDamage;

        public CrocodileAttack(int animationLength, int hitTick, int cooldownTicks) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.REGISTERED));
            this.animationLength = animationLength;
            this.hitTick = hitTick;
            this.cooldownTicks = cooldownTicks;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean checkExtraStartConditions(ServerLevel level, CrocodileEntity entity) {
            if (entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_COOLING_DOWN)) return false;
            if (!CrocodileAI.getAttackTarget(entity).filter(arg_0 -> ((CrocodileEntity)entity).isWithinMeleeAttackRange(arg_0)).isPresent()) return false;
            return true;
        }

        protected void start(ServerLevel level, CrocodileEntity entity, long gameTime) {
            this.elapsedTicks = 0;
            this.dealtDamage = false;
            entity.startAttackAnimation();
        }

        protected boolean canStillUse(ServerLevel level, CrocodileEntity entity, long gameTime) {
            return this.elapsedTicks < this.animationLength && CrocodileAI.getAttackTarget(entity).filter(LivingEntity::isAlive).isPresent();
        }

        protected void tick(ServerLevel level, CrocodileEntity entity, long gameTime) {
            ++this.elapsedTicks;
            CrocodileAI.getAttackTarget(entity).ifPresent(target -> {
                entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                if (!this.dealtDamage && this.elapsedTicks == this.hitTick && entity.isWithinMeleeAttackRange((LivingEntity)target)) {
                    this.dealtDamage = entity.doHurtTarget((Entity)target);
                    if (this.dealtDamage) {
                        entity.playSound((SoundEvent)ReAnimalSoundEvents.CROCODILE_BITE.get(), 1.0f, 1.0f);
                    }
                }
            });
        }

        protected void stop(ServerLevel level, CrocodileEntity entity, long gameTime) {
            entity.setAttacking(false);
            entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)Boolean.TRUE, (long)this.cooldownTicks);
        }
    }
}

