/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.effect;

import it.hurts.shatterbyte.reanimal.init.ReAnimalMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class QuillMobEffect
extends MobEffect {
    public QuillMobEffect() {
        super(MobEffectCategory.BENEFICIAL, 5389624);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        MobEffectInstance effect = target.getEffect(ReAnimalMobEffects.QUILL);
        if (effect == null) {
            return;
        }
        Entity attackerEntity = event.getSource().getEntity();
        if (!(attackerEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)attackerEntity;
        if (attacker == target) {
            return;
        }
        if (target.level().isClientSide()) {
            return;
        }
        float baseMultiplier = (float)(effect.getAmplifier() + 1) * 0.2f;
        float reflected = event.getAmount() * baseMultiplier;
        if (reflected > 0.0f) {
            attacker.hurt(target.damageSources().thorns((Entity)target), reflected);
        }
    }
}

