/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;

public class CrampsMobEffect
extends MobEffect {
    private static final ResourceLocation MOVE_SPEED_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"cramps_move_speed");
    private static final ResourceLocation SWIM_SPEED_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"cramps_swim_speed");

    public CrampsMobEffect() {
        super(MobEffectCategory.HARMFUL, 0x991616);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, MOVE_SPEED_MODIFIER, -0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(NeoForgeMod.SWIM_SPEED, SWIM_SPEED_MODIFIER, -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        entity.hurt(entity.damageSources().cactus(), (float)(1 + amplifier));
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 25 >> amplifier;
        return i == 0 || duration % i == 0;
    }
}

