/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.sound;

import it.hurts.shatterbyte.reanimal.common.entity.dragonfly.DragonflyEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DragonflySoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MAX = 1.2f;
    private static final float SPEED_MIN = 0.01f;
    private final DragonflyEntity dragonfly;

    public DragonflySoundInstance(DragonflyEntity dragonfly) {
        super((SoundEvent)ReAnimalSoundEvents.DRAGONFLY_LOOP.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.dragonfly = dragonfly;
        this.x = (float)dragonfly.getX();
        this.y = (float)dragonfly.getY();
        this.z = (float)dragonfly.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    public void tick() {
        if (!this.dragonfly.isAlive() || this.dragonfly.isRemoved()) {
            this.stop();
            return;
        }
        this.x = (float)this.dragonfly.getX();
        this.y = (float)this.dragonfly.getY();
        this.z = (float)this.dragonfly.getZ();
        if (this.dragonfly.onGround()) {
            this.pitch = 0.0f;
            this.volume = 0.0f;
            return;
        }
        float speed = (float)this.dragonfly.getDeltaMovement().horizontalDistance();
        if (speed >= 0.01f) {
            this.pitch = Mth.lerp((float)Mth.clamp((float)speed, (float)this.getMinPitch(), (float)this.getMaxPitch()), (float)this.getMinPitch(), (float)this.getMaxPitch());
            this.volume = Mth.lerp((float)Mth.clamp((float)speed, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f);
        } else {
            this.pitch = 0.0f;
            this.volume = 0.0f;
        }
    }

    private float getMinPitch() {
        return this.dragonfly.isBaby() ? 1.1f : 0.7f;
    }

    private float getMaxPitch() {
        return this.dragonfly.isBaby() ? 1.5f : 1.1f;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return !this.dragonfly.isSilent();
    }
}

