/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.renderer.ostrich;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.shatterbyte.reanimal.client.model.ostrich.OstrichSaddleModel;
import it.hurts.shatterbyte.reanimal.common.entity.ostrich.OstrichEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class OstrichSaddleLayer
extends GeoRenderLayer<OstrichEntity> {
    public OstrichSaddleLayer(GeoRenderer<OstrichEntity> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, OstrichEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.isSaddled()) {
            return;
        }
        GeoBone bone = bakedModel.getBone("saddle").orElse(null);
        if (bone == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.5f, 0.0f);
        Vector3d modelPos = bone.getModelPosition();
        poseStack.translate(modelPos.x / 16.0, modelPos.y / 16.0, modelPos.z / 16.0);
        OstrichSaddleModel saddleModel = new OstrichSaddleModel();
        RenderType saddleRenderType = RenderType.entityCutoutNoCull((ResourceLocation)saddleModel.getTextureResource(animatable));
        this.getRenderer().reRender(saddleModel.getBakedModel(saddleModel.getModelResource(animatable)), poseStack, bufferSource, (GeoAnimatable)animatable, saddleRenderType, bufferSource.getBuffer(saddleRenderType), partialTick, packedLight, packedOverlay, 0xFFFFFF);
        poseStack.popPose();
    }
}

