/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.renderer.jellyfish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.hurts.shatterbyte.reanimal.client.model.jellyfish.JellyfishModel;
import it.hurts.shatterbyte.reanimal.common.entity.jellyfish.JellyfishEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class JellyfishRenderer
extends GeoEntityRenderer<JellyfishEntity> {
    public JellyfishRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new JellyfishModel());
        this.shadowRadius = 0.3f;
    }

    public RenderType getRenderType(JellyfishEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    public void actuallyRender(PoseStack poseStack, JellyfishEntity animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, 0xF000F0, packedOverlay, colour);
    }

    protected void applyRotations(JellyfishEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTick, scale);
        Vec3 look = entity.getViewVector(partialTick);
        double hor = Math.sqrt(look.x * look.x + look.z * look.z);
        float pitch = (float)Math.toDegrees(Math.atan2(look.y, hor));
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch - 90.0f));
    }
}

