/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.renderer.crocodile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.shatterbyte.reanimal.client.model.crocodile.CrocodileModel;
import it.hurts.shatterbyte.reanimal.common.entity.crocodile.CrocodileEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CrocodileRenderer
extends GeoEntityRenderer<CrocodileEntity> {
    public CrocodileRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CrocodileModel());
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, CrocodileEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.shadowRadius = 0.3f;
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
            this.shadowRadius = 0.6f;
        }
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    protected void applyRotations(CrocodileEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTick, scale);
        if (!entity.isInWaterOrBubble()) {
            return;
        }
        Vec3 look = entity.getViewVector(partialTick);
        double hor = Math.sqrt(look.x * look.x + look.z * look.z);
        float pitch = (float)Math.toDegrees(Math.atan2(look.y, hor));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
    }
}

