/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.model.hippopotamus;

import it.hurts.shatterbyte.reanimal.common.entity.hippopotamus.HippopotamusEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class HippopotamusModel
extends GeoModel<HippopotamusEntity> {
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"geo/hippopotamus.geo.json");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/hippopotamus.png");
    private static final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"animations/hippopotamus.animation.json");

    public ResourceLocation getModelResource(HippopotamusEntity entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(HippopotamusEntity entity) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(HippopotamusEntity entity) {
        return ANIMATION;
    }

    public void setCustomAnimations(HippopotamusEntity animatable, long instanceId, AnimationState<HippopotamusEntity> state) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, state);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        EntityModelData modelData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        float headYaw = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float headPitch = modelData.headPitch() * ((float)Math.PI / 180);
        head.setRotY(headYaw);
        head.setRotX(headPitch);
    }
}

