/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.network;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class SmokePoisonEffectMsg
extends ForgeNetMsg<SmokePoisonEffectMsg> {
    public int entityID;

    public SmokePoisonEffectMsg() {
    }

    public SmokePoisonEffectMsg(LivingEntity entity) {
        this.entityID = entity.getId();
    }

    public SmokePoisonEffectMsg create() {
        return new SmokePoisonEffectMsg();
    }

    public void handle(Level level, Player player) {
        LivingEntity entity;
        Entity entity2 = level.getEntity(this.entityID);
        if (entity2 instanceof LivingEntity && this.canBePoisoned(entity = (LivingEntity)entity2)) {
            int duration = (int)GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.seconds((double)4.0));
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, duration));
        }
    }

    protected boolean canBePoisoned(LivingEntity entity) {
        if (entity instanceof Player) {
            return (Boolean)Smoke.poisonPlayers.get() != false && !this.hasProtection(entity);
        }
        if (entity instanceof Npc) {
            return (Boolean)Smoke.poisonNPCs.get() != false && !this.hasProtection(entity);
        }
        return ForgeEntity.isHostileMob((Entity)entity) ? (Boolean)Smoke.poisonHostileMobs.get() : (Boolean)Smoke.poisonAnimals.get();
    }

    protected boolean hasProtection(LivingEntity entity) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)entity)) {
            String name = stack.getItem().toString();
            if (!StringUtils.containsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"mask", "respirator", "hazmat"})) continue;
            return true;
        }
        return false;
    }
}

