/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.mixin;

import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BrushItem.class})
public abstract class BrushItemMixin
extends Item {
    public BrushItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Redirect(method={"onUseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;", ordinal=0))
    private BlockPos getBlockPos(BlockHitResult hitResult, Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        BlockPos pos = hitResult.getBlockPos();
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            BlockEntity blockEntity = pLevel.getBlockEntity(pos);
            if (blockEntity instanceof RepaintableBlockTile) {
                RepaintableBlockTile tile = (RepaintableBlockTile)blockEntity;
                tile.tryRepaint(player, player.getUsedItemHand());
            }
        }
        return pos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag isAdvanced) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)"Repaints ").append((Component)Component.literal((String)"chimneys, vents or pumps").withStyle(ChatFormatting.GREEN)).append(" if used in one hand while holding a ").append((Component)Component.literal((String)"sample block").withStyle(ChatFormatting.DARK_PURPLE)).append(" in the other."));
            components.add((Component)Component.literal((String)" "));
            components.add((Component)Component.literal((String)"Requires a ").append((Component)Component.literal((String)"bucket of water").withStyle(ChatFormatting.DARK_AQUA)).append(" + ").append((Component)Component.literal((String)"some dyes").withStyle(ChatFormatting.YELLOW)).append(" of any color in the inventory."));
            components.add((Component)Component.literal((String)" "));
            components.add((Component)Component.literal((String)"Each successful repaint consumes one dye."));
        } else {
            components.add((Component)Component.literal((String)"Hold ").append((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.DARK_PURPLE)).append(" for more details"));
        }
        super.appendHoverText(stack, context, components, isAdvanced);
    }
}

