/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.data.ModItemTags;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModLanguageUS
extends LanguageProvider {
    public ModLanguageUS(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    protected void addTranslations() {
        AdChimneys mod = AdChimneys.getInstance();
        Blocks blocks = mod.blocks;
        this.addCreativeModTab("advanced_chimneys");
        this.addBlock(blocks.cobblestone_chimney);
        this.addBlock(blocks.stone_chimney);
        this.addBlock(blocks.small_brick_chimney);
        this.addBlock(blocks.large_brick_chimney);
        this.addBlock(blocks.metal_chimney);
        this.addBlock(blocks.glass_chimney);
        this.addBlock(blocks.stone_vent);
        this.addBlock(blocks.metal_vent);
        this.addBlock(blocks.stone_pump);
        this.addBlock(blocks.metal_pump);
        this.addBlock((Supplier)blocks.pipe, "Pump Pipe");
        this.add(ModItemTags.CHIMNEYS, "Chimneys");
        this.add(ModItemTags.SMALL_BRICKS, "Small Bricks");
        this.add(ModItemTags.LARGE_BRICKS, "Large Bricks");
    }

    protected String displayName(String regName) {
        return Names.localized().join(UnitId.splitRegName((String)regName, (boolean)true, (boolean)false));
    }

    protected void addCreativeModTab(String name) {
        this.add(Names.dotted().join(new String[]{"tabs", "adchimneys", name}), this.displayName(name));
    }

    protected void addBlock(DeferredHolder<Block, ? extends Block> block) {
        this.addBlock((Supplier)block, this.displayName(block.getId().getPath()));
    }
}

