/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModItemModels
extends ItemModelProvider {
    public ModItemModels(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        AdChimneys mod = AdChimneys.getInstance();
        mod.blocks.mapAll().forEach((name, block) -> {
            if (block.get() instanceof Chimney || block.get() instanceof Pump) {
                this.inventoryItem((String)name, (Block)block.get());
            } else {
                this.blockItem((String)name, (Block)block.get());
            }
        });
    }

    protected ItemModelBuilder blockItem(String name, Block block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + name)));
    }

    protected ItemModelBuilder inventoryItem(String name, Block block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + name + "_inventory")));
    }

    protected ItemModelBuilder handHeldItem(DeferredHolder<Item, ? extends Item> item) {
        return this.handHeldItem(item.getId().getPath(), (Item)item.get());
    }

    protected ItemModelBuilder handHeldItem(String name, Item item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", this.modLoc("item/" + name));
    }
}

